/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.document.DialectInstance;
import amf.client.model.domain.DialectDomainElement;
import java.io.File;
import java.util.List;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorApiSpecParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorBaseUriParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorEncodesParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorEndpointParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorMavenGavParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorPaginationParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorSecurityParser;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;

public final class DescriptorParser {
    private DescriptorBaseUriParser descriptorBaseUriParser = new DescriptorBaseUriParser();
    private DescriptorEndpointParser descriptorEndpointParser = new DescriptorEndpointParser();
    private DescriptorApiSpecParser descriptorApiSpecParser = new DescriptorApiSpecParser();
    private DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();
    private DescriptorEncodesParser descriptorEncodesParser = new DescriptorEncodesParser();
    private DescriptorSecurityParser descriptorSecurityParser = new DescriptorSecurityParser();

    public ConnectorDescriptor parseConnectorDescriptor(File connectorDescriptor) throws ModelGenerationException {
        DialectInstance dialectInstance = AMFWrapper.parseConnectorDescriptor(connectorDescriptor);
        DialectDomainElement encodes = dialectInstance.encodes();
        return new ConnectorDescriptor(this.descriptorApiSpecParser.parseApiSpec(encodes), this.parseConnectorName(encodes), this.parseConnectorDescription(encodes), this.descriptorMavenGavParser.parseMavenGav(this.descriptorMavenGavParser.parseConnectorGavElement(encodes)), this.descriptorBaseUriParser.parseBaseUri(encodes), this.descriptorEndpointParser.parseEndpoints(encodes, connectorDescriptor.toPath()), DescriptorParser.parsePaginations(encodes), this.parseSecurity(encodes), this.parseConnectorCategory(encodes), this.parseBaseJavaPackage(encodes), this.parseExtensionXml(encodes), this.parseSkipOutputTypeValidation(encodes), this.parserDefaultInputMediaType(encodes), this.parserDefaultOutputMediaType(encodes));
    }

    private String parserDefaultOutputMediaType(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseDefaultOutputMediaType(encodes);
    }

    private String parserDefaultInputMediaType(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseDefaultInputMediaType(encodes);
    }

    private Boolean parseSkipOutputTypeValidation(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseSkipOutputTypeValidation(encodes);
    }

    private String parseExtensionXml(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseExtensionXml(encodes);
    }

    private String parseBaseJavaPackage(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseJavaPackage(encodes);
    }

    private String parseConnectorCategory(DialectDomainElement encodes) {
        return this.descriptorEncodesParser.parseConnectorCategory(encodes);
    }

    private List<SecuritySchemeDescriptor> parseSecurity(DialectDomainElement encodes) {
        return this.descriptorSecurityParser.parseSecurityScheme(encodes);
    }

    private static List<PaginationDeclarationDescriptor> parsePaginations(DialectDomainElement encodes) {
        return DescriptorPaginationParser.parsePaginationsDescription(encodes);
    }

    private String parseConnectorDescription(DialectDomainElement encodes) {
        return DescriptorParserUtils.parseElementCoreDescription(encodes);
    }

    private String parseConnectorName(DialectDomainElement encodes) {
        return DescriptorParserUtils.parseElementCoreName(encodes);
    }
}

