/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.descriptor.model.RequestDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParameterParser;

public class DescriptorRequestParser {
    private static final Map<String, String> AMF_PARAMETER_TYPE = ImmutableMap.builder().put((Object)ParameterType.URI.getName(), (Object)"uriParameter").put((Object)ParameterType.QUERY.getName(), (Object)"queryString").put((Object)ParameterType.HEADER.getName(), (Object)"header").build();
    private static final String API_CONTRACT_EXPECTS = "http://a.ml/vocabularies/apiContract#expects";
    private static final String API_CONTRACT_PARAMETER_NAMES = "http://a.ml/vocabularies/apiContract#%s";
    private DescriptorParameterParser descriptorParameterParser = new DescriptorParameterParser();

    public RequestDescriptor parseRequest(DialectDomainElement operationElement) {
        DialectDomainElement expectsElement = this.parseExpectsElement(operationElement);
        if (expectsElement == null) {
            return null;
        }
        return new RequestDescriptor(this.descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.HEADER)), this.descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.QUERY)), this.descriptorParameterParser.parseParameters(this.getParametersByType(expectsElement, ParameterType.URI)));
    }

    private List<DialectDomainElement> getParametersByType(DialectDomainElement expects, ParameterType parameterType) {
        String amfParameterType = String.format(API_CONTRACT_PARAMETER_NAMES, AMF_PARAMETER_TYPE.get(parameterType.getName()));
        return new ArrayList<DialectDomainElement>(expects.getObjectPropertyUri(amfParameterType));
    }

    private DialectDomainElement parseExpectsElement(DialectDomainElement operationElement) {
        List expectsElements = operationElement.getObjectPropertyUri(API_CONTRACT_EXPECTS);
        return expectsElements.isEmpty() ? null : (DialectDomainElement)expectsElements.get(0);
    }
}

