/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinition;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.util.NameUtils;

public class SdkParameter
extends JavaTemplateEntity {
    private final Parameter parameter;
    private final SdkTypeDefinition sdkTypeDefinition;
    private final String enumClassName;
    private final String enumClassPackage;

    public SdkParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter) {
        super(outputDir, connectorModel);
        this.parameter = parameter;
        this.sdkTypeDefinition = new SdkTypeDefinition(parameter.getTypeDefinition());
        this.enumClassName = this.sdkTypeDefinition.isEnum() ? SdkParameter.buildEnumName(sdkConnector.getEnumValuesName(), parentJavaName, this) : null;
        this.enumClassPackage = connectorModel.getBasePackage() + ".api.metadata";
    }

    public String getExternalName() {
        return this.parameter.getExternalName();
    }

    public String getJavaName() {
        String javaName = JavaUtils.getJavaLowerCamelNameFromXml(this.parameter.getInternalName());
        if (this.isArrayType()) {
            javaName = NameUtils.pluralize((String)javaName);
        }
        if (JavaUtils.isReservedJavaWord(javaName)) {
            return "j" + javaName;
        }
        return javaName;
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public boolean isArrayType() {
        return this.sdkTypeDefinition.isArrayType();
    }

    private TypeName getTypeName() {
        return this.parameter.getTypeDefinition().isEnum() ? ClassName.get((String)this.enumClassPackage, (String)this.enumClassName, (String[])new String[0]) : this.sdkTypeDefinition.getParameterTypeName();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.sdkTypeDefinition.isEnum()) {
            this.generateEnumClass();
        }
    }

    private void generateEnumClass() throws TemplatingException {
        MethodSpec enumConstructor = MethodSpec.constructorBuilder().addParameter(String.class, "value", new Modifier[0]).addCode(CodeBlock.builder().addStatement("this.value = value", new Object[0]).build()).build();
        MethodSpec valueGetterMethod = MethodSpec.methodBuilder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addCode(CodeBlock.builder().addStatement("return value", new Object[0]).build()).build();
        TypeSpec.Builder enumClassBuilder = TypeSpec.enumBuilder((String)this.enumClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(String.class, "value", new Modifier[]{Modifier.PRIVATE}).addMethod(enumConstructor).addMethod(valueGetterMethod);
        for (String enumConstant : this.parameter.getTypeDefinition().getEnumValues()) {
            enumClassBuilder.addEnumConstant(JavaUtils.removeJavaNameUnwantedCharacters(enumConstant), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{enumConstant}).build());
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.enumClassPackage, (TypeSpec)enumClassBuilder.build());
        this.writeClassToFile(javaFileBuilder.build());
    }

    private static String buildEnumName(Map<List<String>, String> enumValuesName, String parentJavaName, SdkParameter sdkParameter) {
        List enumValuesKey = enumValuesName.keySet().stream().filter(x -> x.equals(sdkParameter.sdkTypeDefinition.getEnumValues())).findFirst().orElse(null);
        if (enumValuesKey != null) {
            return enumValuesName.get(enumValuesKey);
        }
        String parameterNameBasedEnumName = StringUtils.capitalize((String)sdkParameter.getJavaName()) + "Enum";
        if (!enumValuesName.containsValue(parameterNameBasedEnumName)) {
            enumValuesName.put(sdkParameter.sdkTypeDefinition.getEnumValues(), parameterNameBasedEnumName);
            return parameterNameBasedEnumName;
        }
        String operationNameBasedEnumName = parentJavaName + parameterNameBasedEnumName;
        enumValuesName.put(sdkParameter.sdkTypeDefinition.getEnumValues(), operationNameBasedEnumName);
        return operationNameBasedEnumName;
    }

    public ParameterSpec.Builder generateParameterParameter() {
        AnnotationSpec nullSafeAnnotation;
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]);
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            paramSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((nullSafeAnnotation = this.getNullSafeAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(nullSafeAnnotation);
        }
        paramSpecBuilder.addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec summaryAnnotation = this.getSummaryAnnotation();
        if (summaryAnnotation != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return paramSpecBuilder;
    }

    public FieldSpec.Builder generateParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Parameter.class).build();
        return this.generateParameterField(parameterAnnotation);
    }

    public FieldSpec.Builder generateOAuthParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(OAuthParameter.class).addMember("requestAlias", "$S", new Object[]{this.parameter.getExternalName()}).build();
        return this.generateParameterField(parameterAnnotation);
    }

    private FieldSpec.Builder generateParameterField(AnnotationSpec parameterAnnotation) {
        AnnotationSpec summaryAnnotation;
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]).addAnnotation(parameterAnnotation).addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            fieldSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((summaryAnnotation = this.getSummaryAnnotation()) != null) {
            fieldSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return fieldSpecBuilder;
    }

    private AnnotationSpec getNullSafeAnnotation() {
        if (!this.parameter.isRequired() && this.isArrayType()) {
            return AnnotationSpec.builder(NullSafe.class).build();
        }
        return null;
    }

    private AnnotationSpec getOptionalAnnotation() {
        if (!this.parameter.isRequired() || StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
            AnnotationSpec.Builder optionalBuilder = AnnotationSpec.builder(Optional.class);
            if (StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
                optionalBuilder.addMember("defaultValue", "$S", new Object[]{this.parameter.getDefaultValue()});
            }
            return optionalBuilder.build();
        }
        return null;
    }

    private AnnotationSpec getDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.parameter.getDisplayName()}).build();
    }

    private AnnotationSpec getSummaryAnnotation() {
        if (StringUtils.isNotBlank((CharSequence)this.parameter.getDescription())) {
            return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText(this.parameter.getDescription())}).build();
        }
        return null;
    }

    public boolean isNullable() {
        return !this.sdkTypeDefinition.getParameterPrimitiveJavaType().equals(Boolean.TYPE);
    }

    public String getStringValueGetter() {
        return this.getStringValueGetter(this.getJavaName());
    }

    public String getStringValueGetter(String varName) {
        if (this.sdkTypeDefinition.isEnum()) {
            return varName + ".getValue()";
        }
        if (this.sdkTypeDefinition.getJavaType().equals(String.class)) {
            return varName;
        }
        return "String.valueOf(" + varName + ")";
    }
}

