/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPTypeModel;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RPParameterModel
extends APIParameterModel {
    private final TypeDeclaration typeDeclaration;

    public RPParameterModel(TypeDeclaration typeDeclaration, ParameterType parameterType, boolean isPassword) {
        this.typeDeclaration = typeDeclaration;
        this.externalName = typeDeclaration.name();
        this.displayName = this.buildDisplayName();
        this.parameterType = parameterType;
        this.defaultValue = this.buildDefaultValue();
        this.description = this.buildDescription();
        this.isPassword = isPassword;
        this.isRequired = typeDeclaration.required();
        this.typeModel = new RPTypeModel(typeDeclaration, null);
    }

    private String buildDisplayName() {
        return this.typeDeclaration.displayName() != null ? this.typeDeclaration.displayName().value() : this.typeDeclaration.name();
    }

    private String buildDefaultValue() {
        String defaultValue = this.typeDeclaration.defaultValue();
        return StringUtils.isNotBlank((CharSequence)defaultValue) ? defaultValue : null;
    }

    private String buildDescription() {
        return this.typeDeclaration.description() == null ? null : StringUtils.trimToNull((String)this.typeDeclaration.description().value());
    }
}

