/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

import static org.apache.commons.lang.WordUtils.capitalizeFully;

import java.util.Arrays;


public enum ConnectorCategory {

  COMMUNITY, SELECT;

  public String getCategoryName() {
    return capitalizeFully(this.name());
  }

  public static ConnectorCategory fromString(String string) {
    return Arrays.stream(ConnectorCategory.values())
        .filter(x -> x.name().equalsIgnoreCase(string))
        .findFirst().orElse(null);
  }

}
