/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.type;

import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class MultipartTypeDefinition extends TypeDefinition {


  private List<PartParameter> parts;

  MultipartTypeDefinition(String example, List<String> enumValues, TypeSchema typeSchema, List<PartParameter> parts) {
    super(MediaType.MULTIPART_FORM_DATA_TYPE, example, enumValues, typeSchema);
    this.parts = parts;
  }

  public List<PartParameter> getParts() {
    return parts;
  }
}
