/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;

import java.lang.reflect.Type;
import java.nio.file.Path;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;

public class SdkContent extends JavaTemplateEntity {

  private final SdkTypeDefinition sdkTypeDefinition;
  private final SdkInputTypeResolver inputTypeResolver;


  public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
    super(outputDir, connectorModel);

    this.sdkTypeDefinition = new SdkTypeDefinition(sdkConnector, operation, true);
    this.inputTypeResolver =
        new SdkInputTypeResolver(outputDir, connectorModel, operation, operation.getInputMetadata(), sdkTypeDefinition);
  }

  private TypeName getTypeName() {
    Type type = sdkTypeDefinition.getJavaType();

    return ParameterizedTypeName.get(TypedValue.class, type);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    inputTypeResolver.applyTemplates();
  }

  public ParameterSpec generateContentParameter() {
    ParameterSpec.Builder paramSpecBuilder = ParameterSpec
        .builder(getTypeName(), "content")
        .addAnnotation(generateContentAnnotation());

    if (inputTypeResolver.getRequiresTypeResolver()) {
      paramSpecBuilder.addAnnotation(generateTypeResolverAnnotation());
    }

    return paramSpecBuilder.build();
  }

  private AnnotationSpec generateTypeResolverAnnotation() {
    return AnnotationSpec
        .builder(TypeResolver.class)
        .addMember("value", "$T.class", ClassName.get(inputTypeResolver.getPackage(), inputTypeResolver.getClassName()))
        .build();
  }

  private AnnotationSpec generateContentAnnotation() {
    return AnnotationSpec
        .builder(Content.class)
        .addMember("primary", "$L", true)
        .build();
  }
}
