/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.templating.VelocityTemplateEntity;

import java.nio.file.Path;

public class SdkTestLog4j extends VelocityTemplateEntity {

  private final static String LOG_4_J_TEST_VM = "templates/sdk/log4j-test.vm";

  public SdkTestLog4j(Path outputDir) {
    super(outputDir);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(LOG_4_J_TEST_VM, outputDir.resolve("src/test/resources/log4j-test.xml"));
  }
}
