/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static javax.ws.rs.core.MediaType.valueOf;
import static org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinitionUtils.getJavaType;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.JsonInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.StringInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.UnspecifiedCsvInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.XmlInputTypeResolver;

import java.io.InputStream;
import java.nio.file.Path;

public class SdkInputTypeResolver extends SdkAbstractStaticTypeResolver {

  private String qName;

  public SdkInputTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                              ConnectorOperation operation, TypeDefinition typeDefinition,
                              FileGenerationUtils.SchemaNameType schemaNameType,
                              String partName) {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
  }

  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
    if (typeDefinition.getMediaType().equals(APPLICATION_XML_TYPE)) {
      qName = ((XmlTypeSchema) typeDefinition.getTypeSchema()).getElementName();
      return XmlInputTypeResolver.class;
    } else if (typeDefinition.getMediaType().equals(APPLICATION_JSON_TYPE)) {
      return JsonInputTypeResolver.class;
    } else if (typeDefinition.getMediaType().equals(valueOf("text/csv"))
        || typeDefinition.getMediaType().equals(valueOf("application/csv"))) {
      return UnspecifiedCsvInputTypeResolver.class;
    } else {
      return StringInputTypeResolver.class;
    }
  }

  @Override
  protected String getClassNameSuffix() {
    return "InputTypeResolver";
  }

  @Override
  protected boolean requiresQNameMethod() {
    return superclass.equals(XmlInputTypeResolver.class);
  }

  @Override
  protected String getQName() {
    return qName;
  }

  @Override
  protected boolean buildRequiresTypeResolver() {
    return !(typeDefinition instanceof EmptyTypeDefinition) &&
        (getJavaType(typeDefinition).equals(InputStream.class) || getJavaType(typeDefinition).equals(String.class));
  }

}
