/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;

import com.squareup.javapoet.AnnotationSpec;

import java.nio.file.Path;

public class SdkOutputMetadata extends JavaTemplateEntity {

  private final SdkOutputTypeResolver sdkOutputTypeResolver;


  public SdkOutputMetadata(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                           ConnectorOperation operation) {
    super(outputDir, connectorModel);

    if (operation.hasPagination()) {
      this.sdkOutputTypeResolver =
          new SdkPagingTypeResolver(outputDir,
                                    connectorModel,
                                    sdkConnector,
                                    operation,
                                    operation.getOutputMetadata());
    } else {
      sdkOutputTypeResolver =
          new SdkOutputTypeResolver(outputDir,
                                    connectorModel,
                                    sdkConnector,
                                    operation,
                                    operation.getOutputMetadata());
    }
  }


  @Override
  public void applyTemplates() throws TemplatingException {
    sdkOutputTypeResolver.applyTemplates();
  }

  public boolean requiresOutputResolver() {
    return sdkOutputTypeResolver.getRequiresTypeResolver();
  }

  public AnnotationSpec generateOutputResolverAnnotation() {
    return sdkOutputTypeResolver.getOutputTypeResolverAnnotation();
  }
}
