/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinitionUtils.getJavaType;
import static org.mule.connectivity.restconnect.internal.util.FileGenerationUtils.SchemaNameType.OUTPUT;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.JsonOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.StringOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.XmlOutputTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;

import java.io.InputStream;
import java.nio.file.Path;

public class SdkOutputTypeResolver extends SdkAbstractStaticTypeResolver {

  private String qName;

  public SdkOutputTypeResolver(Path outputDir,
                               ConnectorModel connectorModel,
                               SdkConnector sdkConnector,
                               ConnectorOperation operation,
                               TypeDefinition typeDefinition) {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, OUTPUT, EMPTY);
  }

  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
    if (typeDefinition.getMediaType().equals(APPLICATION_XML_TYPE)) {
      qName = ((XmlTypeSchema) typeDefinition.getTypeSchema()).getElementName();
      return XmlOutputTypeResolver.class;
    } else if (typeDefinition.getMediaType().equals(APPLICATION_JSON_TYPE)) {
      return JsonOutputTypeResolver.class;
    } else {
      return StringOutputTypeResolver.class;
    }
  }

  public AnnotationSpec getOutputTypeResolverAnnotation() {
    return AnnotationSpec
        .builder(OutputResolver.class)
        .addMember("output", "$T.class", ClassName.get(getPackage(), getClassName()))
        .build();
  }

  @Override
  protected String getClassNameSuffix() {
    return "OutputTypeResolver";
  }

  @Override
  protected boolean requiresQNameMethod() {
    return superclass.equals(XmlOutputTypeResolver.class);
  }

  @Override
  protected String getQName() {
    return qName;
  }

  @Override
  protected boolean buildRequiresTypeResolver() {
    return !(typeDefinition instanceof EmptyTypeDefinition) && getJavaType(typeDefinition).equals(InputStream.class);
  }


}
