/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.isXmlSchema;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.SchemaShape;

import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;

import javax.ws.rs.core.MediaType;

public class AMFTypeSchemaModel extends APITypeSchemaModel {

  public AMFTypeSchemaModel(AnyShape shape, MediaType mediaType) {
    this.typeSchema = buildTypeSchema(shape, mediaType);
  }

  private TypeSchema buildTypeSchema(AnyShape shape, MediaType mediaType) {

    TypeSchema newTypeSchema;

    if (shape instanceof SchemaShape && ((SchemaShape) shape).raw().nonEmpty()) {
      SchemaShape schemaShape = (SchemaShape) shape;

      if (isXmlSchemaShape(schemaShape)) {
        newTypeSchema = buildXmlTypeSchema(schemaShape);
      } else {
        newTypeSchema = new JsonTypeSchema(schemaShape.raw().value());
      }
    }

    else if (APPLICATION_JSON_TYPE.equals(mediaType)) {
      newTypeSchema = new JsonTypeSchema(new AMFTypeSchemaSupplier(shape, APPLICATION_JSON_TYPE));
    }

    else if (APPLICATION_XML_TYPE.equals(mediaType)) {
      newTypeSchema = new XmlTypeSchema(new AMFTypeSchemaSupplier(shape, APPLICATION_XML_TYPE));
    }

    else {
      //TODO: RESTC-827: Generate a Json Schema that is latter used to create an appropriate type resolver.
      newTypeSchema = new CustomTypeSchema(new AMFTypeSchemaSupplier(shape, mediaType), mediaType);
    }

    return newTypeSchema;
  }

  public static boolean isXmlSchemaShape(SchemaShape schemaShape) {
    return schemaShape.raw().nonEmpty() && isXmlSchema(schemaShape.raw().value());
  }

  private TypeSchema buildXmlTypeSchema(SchemaShape schemaShape) {

    String elementName = schemaShape.annotations().fragmentName().orElse(null);
    String path = schemaShape.location().orElse(null);

    return new XmlTypeSchema(schemaShape.raw().value(), elementName, path);
  }
}
