/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PartDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.util.NamingUtil;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;

public class ConnectorParameterBuilder {
    private final ConnectorTypeDefinitionBuilder typeDefinitionBuilder;

    public ConnectorParameterBuilder(ConnectorTypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        this.typeDefinitionBuilder = connectorTypeDefinitionBuilder;
    }

    public List<Parameter> buildParameterList(List<APIParameterModel> parametersModel, OperationDescriptor operationDescriptor, List<String> parameterCollisionInternalNames) throws ModelGenerationException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        LinkedList<String> collisionNames = new LinkedList<String>(parameterCollisionInternalNames);
        for (APIParameterModel parameterModel : parametersModel) {
            Parameter parameter = this.buildParameter(parameterModel, ConnectorParameterBuilder.getParameterDescriptor(parameterModel, operationDescriptor), collisionNames);
            parameterList.add(parameter);
            collisionNames.add(parameter.getInternalName());
        }
        return parameterList;
    }

    public List<Parameter> buildParameterList(List<APIParameterModel> parametersModel, SecuritySchemeDescriptor securitySchemeDescriptor, List<String> parameterCollisionInternalNames) throws ModelGenerationException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        LinkedList<String> collisionNames = new LinkedList<String>(parameterCollisionInternalNames);
        for (APIParameterModel parameterModel : parametersModel) {
            Parameter parameter = this.buildParameter(parameterModel, ConnectorParameterBuilder.getParameterDescriptor(parameterModel, securitySchemeDescriptor), collisionNames);
            parameterList.add(parameter);
            collisionNames.add(parameter.getInternalName());
        }
        return parameterList;
    }

    private static ParameterDescriptor getParameterDescriptor(APIParameterModel parameterModel, SecuritySchemeDescriptor securitySchemeDescriptor) {
        if (securitySchemeDescriptor == null) {
            return null;
        }
        List<Object> parameterDescriptors = new LinkedList();
        if (securitySchemeDescriptor.getHeaders() != null) {
            if (parameterModel.getParameterType().equals((Object)ParameterType.HEADER)) {
                parameterDescriptors = securitySchemeDescriptor.getHeaders();
            }
            if (parameterModel.getParameterType().equals((Object)ParameterType.QUERY)) {
                parameterDescriptors = securitySchemeDescriptor.getQueryParameters();
            }
        }
        return parameterDescriptors.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getParamName())).filter(x -> x.getParamName().equalsIgnoreCase(parameterModel.getExternalName())).findFirst().orElse(null);
    }

    private static ParameterDescriptor getParameterDescriptor(APIParameterModel parameterModel, OperationDescriptor operationDescriptor) {
        if (operationDescriptor == null) {
            return null;
        }
        List<Object> parameterDescriptors = new LinkedList();
        if (operationDescriptor.getExpects() != null) {
            if (parameterModel.getParameterType().equals((Object)ParameterType.URI)) {
                parameterDescriptors = operationDescriptor.getExpects().getUriParameter();
            } else if (parameterModel.getParameterType().equals((Object)ParameterType.QUERY)) {
                parameterDescriptors = operationDescriptor.getExpects().getQueryParameter();
            } else if (parameterModel.getParameterType().equals((Object)ParameterType.HEADER)) {
                parameterDescriptors = operationDescriptor.getExpects().getHeader();
            }
        }
        return parameterDescriptors.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getParamName())).filter(x -> x.getParamName().equalsIgnoreCase(parameterModel.getExternalName())).findFirst().orElse(null);
    }

    public Parameter buildParameter(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor, List<String> collisionInternalNames) throws ModelGenerationException {
        return new Parameter(ConnectorParameterBuilder.buildDisplayName(apiParameterModel, parameterDescriptor), apiParameterModel.getExternalName(), apiParameterModel.getParameterType(), this.buildParameterTypeDefinition(apiParameterModel.getTypeModel(), null), ConnectorParameterBuilder.buildDescription(apiParameterModel, parameterDescriptor), apiParameterModel.isRequired(), apiParameterModel.getDefaultValue(), apiParameterModel.isPassword(), collisionInternalNames);
    }

    private static String buildDisplayName(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor) {
        String displayName = parameterDescriptor != null && StringUtils.isNotBlank((CharSequence)parameterDescriptor.getParamName()) ? parameterDescriptor.getFriendlyName() : apiParameterModel.getDisplayName();
        if (!NamingUtil.isFriendlyName(displayName)) {
            displayName = NamingUtil.makeNameFriendly(displayName);
        }
        return displayName;
    }

    private static String buildDescription(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor != null && StringUtils.isNotBlank((CharSequence)parameterDescriptor.getParamName())) {
            return parameterDescriptor.getDescription();
        }
        return apiParameterModel.getDescription();
    }

    private TypeDefinition buildParameterTypeDefinition(APITypeModel typeModel, @Nullable MediaType mediaType) throws ModelGenerationException {
        if (mediaType == null) {
            mediaType = typeModel.getMediaType() != null ? typeModel.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
        }
        return this.typeDefinitionBuilder.buildTypeDefinition(typeModel, null, mediaType);
    }

    public PartParameter buildPartParameter(APIParameterModel apiParameterModel, @Nullable PartDescriptor partDescriptor) throws ModelGenerationException {
        MediaType mediaType = null;
        if (partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getContentType())) {
            mediaType = MediaType.valueOf((String)partDescriptor.getContentType());
        }
        TypeDefinition partTypeDefinition = partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getInputType()) ? this.typeDefinitionBuilder.buildTypeDefinition(partDescriptor.getInputType(), mediaType) : this.buildParameterTypeDefinition(apiParameterModel.getTypeModel(), mediaType);
        return new PartParameter(partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getFriendlyName()) ? partDescriptor.getFriendlyName() : apiParameterModel.getDisplayName(), apiParameterModel.getExternalName(), partTypeDefinition, partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getDescription()) ? partDescriptor.getDescription() : apiParameterModel.getDescription(), partDescriptor != null && partDescriptor.isFilePart());
    }
}

