/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorParameterBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeSchemaBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ObjectTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.UnionTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.descriptor.model.PartDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;

public class ConnectorTypeDefinitionBuilder {
    private final ConnectorTypeSchemaBuilder typeSchemaBuilder;
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorTypeDefinitionBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaBuilder = new ConnectorTypeSchemaBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this);
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        return this.buildTypeDefinition(apiTypeModel, partDescriptors, apiTypeModel.getMediaType());
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors, MediaType mediaType) throws ModelGenerationException {
        TypeDefinition.Builder typeDefinitionBuilder = TypeDefinition.builder(mediaType, this.typeSchemaBuilder.buildTypeSchema(apiTypeModel.getAPITypeSchemaModel()), apiTypeModel.getEnumValues(), apiTypeModel.getExample());
        Class<? extends TypeDefinition> typeDefinitionClass = apiTypeModel.getTypeDefinitionClass();
        if (typeDefinitionClass == null) {
            return null;
        }
        if (typeDefinitionClass.equals(EmptyTypeDefinition.class)) {
            return typeDefinitionBuilder.buildEmptyTypeDefinition();
        }
        if (typeDefinitionClass.equals(PrimitiveTypeDefinition.class)) {
            return typeDefinitionBuilder.buildPrimitiveTypeDefinition(this.buildPrimitiveType(apiTypeModel.getPrimitiveTypeModel()));
        }
        if (typeDefinitionClass.equals(ObjectTypeDefinition.class)) {
            return typeDefinitionBuilder.buildObjectTypeDefinition();
        }
        if (typeDefinitionClass.equals(ArrayTypeDefinition.class)) {
            MediaType innerMediaType = apiTypeModel.getInnerType().getMediaType() != null ? apiTypeModel.getInnerType().getMediaType() : mediaType;
            return typeDefinitionBuilder.buildArrayType(this.buildTypeDefinition(apiTypeModel.getInnerType(), null, innerMediaType));
        }
        if (typeDefinitionClass.equals(UnionTypeDefinition.class)) {
            ArrayList<TypeDefinition> unionTypes = new ArrayList<TypeDefinition>();
            for (APITypeModel typeModel : apiTypeModel.getUnionTypes()) {
                TypeDefinition typeDefinition = this.buildTypeDefinition(typeModel, null, mediaType);
                unionTypes.add(typeDefinition);
            }
            return typeDefinitionBuilder.buildUnionTypeDefinition(unionTypes);
        }
        if (typeDefinitionClass.equals(MultipartTypeDefinition.class)) {
            ArrayList<PartParameter> parts = new ArrayList<PartParameter>();
            for (APIParameterModel apiParameterModel : apiTypeModel.getParts()) {
                PartDescriptor partDescriptor = null;
                if (partDescriptors != null) {
                    partDescriptor = partDescriptors.stream().filter(x -> x.getPartName().equals(apiParameterModel.getExternalName())).findFirst().orElse(null);
                }
                PartParameter partParameter = this.parameterBuilder.buildPartParameter(apiParameterModel, partDescriptor);
                parts.add(partParameter);
            }
            return typeDefinitionBuilder.buildMultipartTypeDefinition(parts);
        }
        return null;
    }

    public TypeDefinition buildTypeDefinition(String rawSchema, MediaType mediaType) throws ModelGenerationException {
        TypeSchema typeSchema = this.typeSchemaBuilder.buildTypeSchema(rawSchema);
        if (mediaType == null) {
            mediaType = typeSchema instanceof XmlTypeSchema ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
        return TypeDefinition.builder(mediaType, typeSchema, null, null).buildObjectTypeDefinition();
    }

    private PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(APIPrimitiveTypeModel primitiveTypeModel) {
        return primitiveTypeModel.getPrimitiveType();
    }
}

