/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.List;
import org.mule.connectivity.restconnect.internal.descriptor.model.MavenGavDescriptor;

public class DescriptorMavenGavParser {
    private static final String REST_CONNECT_CONNECTOR_GAV = "http://a.ml/vocabularies/restConnect#connectorGav";
    private static final String ANYPOINT_TENANT_ID = "http://anypoint.com/vocabs/anypoint#tenantId";
    private static final String DIGITAL_REPOSITORY_ARTIFACT_ID = "http://anypoint.com/vocabs/digital-repository#assetId";
    private static final String SCHEMA_ORG_VERSION = "http://anypoint.com/vocabs/schema-org#version";

    public MavenGavDescriptor parseMavenGav(DialectDomainElement mavenGavElement) {
        if (mavenGavElement == null) {
            return null;
        }
        return new MavenGavDescriptor(this.parseGroupId(mavenGavElement), this.parseArtifactId(mavenGavElement), this.parseVersion(mavenGavElement));
    }

    public DialectDomainElement parseConnectorGavElement(DialectDomainElement encodes) {
        List mavenGavElements = encodes.getObjectPropertyUri(REST_CONNECT_CONNECTOR_GAV);
        return mavenGavElements.isEmpty() ? null : (DialectDomainElement)mavenGavElements.get(0);
    }

    private String parseGroupId(DialectDomainElement mavenGavElement) {
        List groupIds = mavenGavElement.getScalarByPropertyUri(ANYPOINT_TENANT_ID);
        return groupIds.isEmpty() ? null : groupIds.get(0).toString();
    }

    private String parseArtifactId(DialectDomainElement mavenGavElement) {
        List artifactIds = mavenGavElement.getScalarByPropertyUri(DIGITAL_REPOSITORY_ARTIFACT_ID);
        return artifactIds.isEmpty() ? null : artifactIds.get(0).toString();
    }

    private String parseVersion(DialectDomainElement mavenGavElement) {
        List versions = mavenGavElement.getScalarByPropertyUri(SCHEMA_ORG_VERSION);
        return versions.isEmpty() ? null : versions.get(0).toString();
    }
}

