/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import java.io.InputStream;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinitionUtils;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.JsonInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.StringInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.UnspecifiedCsvInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.XmlInputTypeResolver;

public class SdkInputTypeResolver
extends SdkAbstractStaticTypeResolver {
    private String qName;

    public SdkInputTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtils.SchemaNameType schemaNameType, String partName) {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
        if (typeDefinition.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlInputTypeResolver.class;
        }
        if (typeDefinition.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return JsonInputTypeResolver.class;
        }
        if (typeDefinition.getMediaType().equals((Object)MediaType.valueOf((String)"text/csv")) || typeDefinition.getMediaType().equals((Object)MediaType.valueOf((String)"application/csv"))) {
            return UnspecifiedCsvInputTypeResolver.class;
        }
        return StringInputTypeResolver.class;
    }

    @Override
    protected String getClassNameSuffix() {
        return "InputTypeResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlInputTypeResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean buildRequiresTypeResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition) && (SdkTypeDefinitionUtils.getJavaType(this.typeDefinition).equals(InputStream.class) || SdkTypeDefinitionUtils.getJavaType(this.typeDefinition).equals(String.class));
    }
}

