/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import java.nio.file.Path;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkOutputTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkPagingTypeResolver;

public class SdkOutputMetadata
extends JavaTemplateEntity {
    private final SdkOutputTypeResolver sdkOutputTypeResolver;

    public SdkOutputMetadata(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
        super(outputDir, connectorModel);
        this.sdkOutputTypeResolver = operation.hasPagination() ? new SdkPagingTypeResolver(outputDir, connectorModel, sdkConnector, operation, operation.getOutputMetadata()) : new SdkOutputTypeResolver(outputDir, connectorModel, sdkConnector, operation, operation.getOutputMetadata());
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.sdkOutputTypeResolver.applyTemplates();
    }

    public boolean requiresOutputResolver() {
        return this.sdkOutputTypeResolver.getRequiresTypeResolver();
    }

    public AnnotationSpec generateOutputResolverAnnotation() {
        return this.sdkOutputTypeResolver.getOutputTypeResolverAnnotation();
    }
}

