/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import java.io.InputStream;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinitionUtils;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.JsonOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.StringOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.XmlOutputTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;

public class SdkOutputTypeResolver
extends SdkAbstractStaticTypeResolver {
    private String qName;

    public SdkOutputTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition) {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, FileGenerationUtils.SchemaNameType.OUTPUT, "");
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
        if (typeDefinition.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlOutputTypeResolver.class;
        }
        if (typeDefinition.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return JsonOutputTypeResolver.class;
        }
        return StringOutputTypeResolver.class;
    }

    public AnnotationSpec getOutputTypeResolverAnnotation() {
        return AnnotationSpec.builder(OutputResolver.class).addMember("output", "$T.class", new Object[]{ClassName.get((String)this.getPackage(), (String)this.getClassName(), (String[])new String[0])}).build();
    }

    @Override
    protected String getClassNameSuffix() {
        return "OutputTypeResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlOutputTypeResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean buildRequiresTypeResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition) && SdkTypeDefinitionUtils.getJavaType(this.typeDefinition).equals(InputStream.class);
    }
}

