/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.SchemaShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFTypeSchemaModel;

public class AMFParameterModel
extends APIParameterModel {
    public AMFParameterModel(Parameter parameter, ParameterType parameterType, boolean isPassword) {
        this.externalName = parameter.name().value();
        this.displayName = this.buildDisplayName(parameter);
        this.parameterType = parameterType;
        this.defaultValue = this.buildDefaultValue(parameter);
        this.description = parameter.description().value();
        this.isPassword = isPassword;
        this.isRequired = parameter.required().value();
        this.typeModel = new AMFTypeModel((AnyShape)parameter.schema(), this.getDefaultMediaType(parameter.schema()));
    }

    private String buildDisplayName(Parameter parameter) {
        return !parameter.schema().displayName().isNullOrEmpty() ? parameter.schema().displayName().value() : parameter.name().value();
    }

    public AMFParameterModel(PropertyShape propertyShape, ParameterType parameterType) {
        this.externalName = propertyShape.id().substring(propertyShape.id().lastIndexOf(47) + 1);
        this.displayName = propertyShape.displayName().nonEmpty() ? propertyShape.displayName().value() : (propertyShape.range().displayName().nonEmpty() ? propertyShape.range().displayName().value() : this.externalName);
        this.description = propertyShape.description().nonEmpty() ? propertyShape.description().value() : propertyShape.range().description().value();
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel((AnyShape)propertyShape.range(), this.getDefaultMediaType(propertyShape.range()));
    }

    public AMFParameterModel(String name, ParameterType parameterType, AMFPrimitiveTypeModel amfPrimitiveTypeParser) {
        this.displayName = this.externalName = name;
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel(amfPrimitiveTypeParser);
    }

    private String buildDefaultValue(Parameter parameter) {
        return parameter.schema().defaultValueStr().nonEmpty() ? parameter.schema().defaultValueStr().value() : "";
    }

    private String getDefaultMediaType(Shape shape) {
        if (shape instanceof FileShape) {
            return "application/octet-stream";
        }
        if (shape instanceof NodeShape || shape instanceof ArrayShape || shape instanceof UnionShape) {
            return "application/json";
        }
        if (shape instanceof SchemaShape) {
            if (AMFTypeSchemaModel.isXmlSchemaShape((SchemaShape)shape)) {
                return "application/xml";
            }
            return "application/json";
        }
        return "text/plain";
    }
}

