/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPSecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.util.OperationNamingUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.security.SecuritySchemeRef;

public class RPOperationModel
extends APIOperationModel {
    private final Api api;
    private final Method method;

    public RPOperationModel(Api api, Method method) throws ModelGenerationException {
        this.api = api;
        this.method = method;
        this.description = this.buildDescription();
        this.path = this.buildPath();
        this.httpMethod = HTTPMethod.fromString(method.method());
        this.name = this.buildName(this.httpMethod, this.path);
        this.uriParamsModel = this.buildUriParamsModel();
        this.queryParamsModel = this.buildQueryParamsModel();
        this.headersModel = this.buildHeadersModel();
        this.inputMetadataModel = this.buildInputMetadataModels();
        this.outputMetadataModel = this.buildOutputMetadataModels();
        this.securitySchemesModel = this.buildSecuritySchemesModel();
    }

    private String buildDescription() {
        String description = null;
        if (this.method.description() != null) {
            description = this.method.description().value();
        } else if (this.method.resource() != null && Objects.requireNonNull(this.method.resource()).description() != null) {
            description = Objects.requireNonNull(this.method.resource()).description().value();
        }
        return StringUtils.trimToNull((String)description);
    }

    private String buildPath() {
        return Objects.requireNonNull(this.method.resource()).resourcePath();
    }

    private String buildName(HTTPMethod httpMethod, String path) {
        if (this.method.displayName() != null && this.method.displayName().value() != null && !this.method.displayName().value().equals(this.method.method())) {
            return StringUtils.trimToNull((String)this.method.displayName().value());
        }
        return OperationNamingUtils.buildFriendlyCanonicalOperationName(httpMethod, path);
    }

    private List<APIParameterModel> buildUriParamsModel() {
        ArrayList<APIParameterModel> uriParametersModel = new ArrayList<APIParameterModel>();
        for (Resource resource = this.method.resource(); resource != null; resource = resource.parentResource()) {
            for (APIParameterModel uriParamModel : this.getParameterList(resource.uriParameters(), ParameterType.URI)) {
                if (!uriParametersModel.stream().noneMatch(y -> y.getExternalName().equalsIgnoreCase(uriParamModel.getExternalName()))) continue;
                uriParametersModel.add(0, uriParamModel);
            }
        }
        return uriParametersModel;
    }

    private List<APIParameterModel> buildQueryParamsModel() {
        return this.getParameterList(this.method.queryParameters(), ParameterType.QUERY);
    }

    private List<APIParameterModel> buildHeadersModel() {
        return this.getParameterList(this.method.headers(), ParameterType.HEADER);
    }

    private List<APIParameterModel> getParameterList(List<TypeDeclaration> typeDeclarations, ParameterType parameterType) {
        LinkedList<APIParameterModel> parametersModel = new LinkedList<APIParameterModel>();
        for (TypeDeclaration td : typeDeclarations) {
            parametersModel.add(new RPParameterModel(td, parameterType, false));
        }
        return parametersModel;
    }

    private List<APITypeModel> buildInputMetadataModels() {
        LinkedList<APITypeModel> typeModels = new LinkedList<APITypeModel>();
        for (TypeDeclaration td : this.method.body()) {
            typeModels.add(new RPTypeModel(td, td.name()));
        }
        return typeModels;
    }

    private List<APITypeModel> buildOutputMetadataModels() {
        List possibleResponses = this.method.responses().stream().filter(x -> this.hasBody((Response)x) && this.isOkResponse((Response)x)).collect(Collectors.toList());
        LinkedList<APITypeModel> typeModels = new LinkedList<APITypeModel>();
        for (Response response : possibleResponses) {
            for (TypeDeclaration td : response.body()) {
                typeModels.add(new RPTypeModel(td, td.name()));
            }
        }
        return typeModels;
    }

    private boolean hasBody(Response response) {
        return response.body() != null && !response.body().isEmpty();
    }

    private boolean isOkResponse(Response response) {
        return response.code().value().startsWith("2");
    }

    private List<APISecuritySchemeModel> buildSecuritySchemesModel() throws ModelGenerationException {
        List globalSchemes = this.api.securedBy().stream().filter(Objects::nonNull).map(SecuritySchemeRef::securityScheme).filter(Objects::nonNull).collect(Collectors.toList());
        List endPointSchemes = this.method.resource().securedBy().stream().filter(Objects::nonNull).map(SecuritySchemeRef::securityScheme).filter(Objects::nonNull).collect(Collectors.toList());
        List methodSchemes = this.method.securedBy().stream().filter(Objects::nonNull).map(SecuritySchemeRef::securityScheme).filter(Objects::nonNull).collect(Collectors.toList());
        List selectedSchemes = this.selectSecuritySchemes(methodSchemes, endPointSchemes, globalSchemes);
        List<Object> securitySchemesModel = new ArrayList();
        if (!selectedSchemes.isEmpty()) {
            for (SecurityScheme securityScheme : selectedSchemes) {
                securitySchemesModel.add(new RPSecuritySchemeModel(securityScheme));
            }
        }
        securitySchemesModel = securitySchemesModel.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!selectedSchemes.isEmpty() && securitySchemesModel.isEmpty()) {
            throw new UnsupportedSecuritySchemeException(this.httpMethod.toString() + " " + this.path + ": None of the specified security schemes are supported.");
        }
        return securitySchemesModel;
    }
}

