/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPTypeSchemaSupplier;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;

public class RPTypeSchemaModel
extends APITypeSchemaModel {
    public RPTypeSchemaModel(TypeDeclaration typeDeclaration, MediaType mediaType) {
        this.typeSchema = this.buildTypeSchema(typeDeclaration, mediaType);
    }

    private TypeSchema buildTypeSchema(TypeDeclaration typeDeclaration, MediaType mediaType) {
        TypeSchema newTypeSchema;
        if (typeDeclaration instanceof ExternalTypeDeclaration && StringUtils.isNotBlank((String)((ExternalTypeDeclaration)typeDeclaration).schemaContent())) {
            ExternalTypeDeclaration externalTypeDeclaration = (ExternalTypeDeclaration)typeDeclaration;
            newTypeSchema = typeDeclaration instanceof XMLTypeDeclaration ? RPTypeSchemaModel.buildXmlTypeSchema((XMLTypeDeclaration)typeDeclaration) : new JsonTypeSchema(externalTypeDeclaration.schemaContent());
        } else {
            newTypeSchema = MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType) ? new JsonTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, MediaType.APPLICATION_JSON_TYPE)) : (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType) ? new XmlTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, MediaType.APPLICATION_XML_TYPE)) : new CustomTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, mediaType), mediaType));
        }
        return newTypeSchema;
    }

    private static TypeSchema buildXmlTypeSchema(XMLTypeDeclaration xmlTypeDeclaration) {
        String elementName = StringUtils.isNotBlank((String)xmlTypeDeclaration.internalFragment()) ? xmlTypeDeclaration.internalFragment() : null;
        String path = xmlTypeDeclaration.schemaPath();
        return new XmlTypeSchema(xmlTypeDeclaration.schemaContent(), elementName, path);
    }
}

