/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;

import java.util.ArrayList;
import java.util.List;

import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils.parseRestConnectIgnored;

public class DescriptorSecurityParser {

  private static final String AML_REST_CONNECT_SECURITY_SCHEME = "http://a.ml/vocabularies/restConnect#security";
  private static final String AML_REST_CONNECT_SECURITY_HEADERS = "http://a.ml/vocabularies/restConnect#securityHeaders";
  private static final String AML_REST_CONNECT_SECURITY_QUERY_PARAMETERS =
      "http://a.ml/vocabularies/restConnect#securityQueryParameters";

  private DescriptorParameterParser descriptorParameterParser = new DescriptorParameterParser();

  public List<SecuritySchemeDescriptor> parseSecurityScheme(DialectDomainElement element) {
    List<DialectDomainElement> securityDescriptors = element.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_SCHEME);
    List<SecuritySchemeDescriptor> securitySchemeDescriptors = new ArrayList<>(securityDescriptors.size());
    for (DialectDomainElement securityElement : securityDescriptors) {
      SecuritySchemeDescriptor securitySchemeDescriptor =
          new SecuritySchemeDescriptor(securityElement.localRefName(), parseHeaders(securityElement),
                                       parseQueryParameters(securityElement), parseRestConnectIgnored(securityElement));
      securitySchemeDescriptors.add(securitySchemeDescriptor);
    }
    return securitySchemeDescriptors;
  }

  private List<ParameterDescriptor> parseHeaders(DialectDomainElement securityElement) {
    List<DialectDomainElement> apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_HEADERS);
    return apiSpecElements.isEmpty() ? null : descriptorParameterParser.parseParameters(apiSpecElements);
  }

  private List<ParameterDescriptor> parseQueryParameters(DialectDomainElement securityElement) {
    List<DialectDomainElement> apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_QUERY_PARAMETERS);
    return apiSpecElements.isEmpty() ? null : descriptorParameterParser.parseParameters(apiSpecElements);
  }

}
