/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ConnectorTypeSchemaBuilder {
    private TypeSchemaPool typeSchemaPool;

    public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaPool = typeSchemaPool;
    }

    public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) throws ModelGenerationException {
        if (apiTypeSchemaModel == null) {
            return null;
        }
        return this.getUniqueTypeSchema(apiTypeSchemaModel.getTypeSchema());
    }

    public TypeSchema buildTypeSchema(String rawSchema) throws ModelGenerationException {
        if (XmlUtils.isXmlSchema(rawSchema)) {
            return this.getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
        }
        return this.getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }

    private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) throws ModelGenerationException {
        if (typeSchema != null && StringUtils.isNotBlank((String)typeSchema.getRawSchema())) {
            if (this.typeSchemaPool.containsTypeSchema(typeSchema.getRawSchema())) {
                return this.typeSchemaPool.getTypeSchema(typeSchema.getRawSchema());
            }
            this.typeSchemaPool.putTypeSchema(typeSchema.getRawSchema(), typeSchema);
        }
        return typeSchema;
    }
}

