/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.List;

public class DescriptorEncodesParser {
    private static final String SKIP_OUTPUT_TYPE_VALIDATION = "http://a.ml/vocabularies/restConnect#skipOutputTypeValidation";
    private static final String EXTENSION_XML = "http://a.ml/vocabularies/restConnect#extensionXml";
    private static final String CONNECTOR_CATEGORY = "http://a.ml/vocabularies/restConnect#connectorCategory";
    private static final String CUSTOM_JAVA_PACKAGE = "http://a.ml/vocabularies/restConnect#baseJavaPackage";
    private static final String DEFAULT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#defaultInputMediaType";
    private static final String DEFAULT_OUTPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#defaultOutputMediaType";

    public String parseJavaPackage(DialectDomainElement element) {
        List javaPackages = element.getScalarByPropertyUri(CUSTOM_JAVA_PACKAGE);
        return javaPackages.isEmpty() ? null : javaPackages.get(0).toString();
    }

    public String parseConnectorCategory(DialectDomainElement element) {
        List connectorCategories = element.getScalarByPropertyUri(CONNECTOR_CATEGORY);
        return connectorCategories.isEmpty() ? null : connectorCategories.get(0).toString();
    }

    public String parseExtensionXml(DialectDomainElement element) {
        List extensionXmls = element.getScalarByPropertyUri(EXTENSION_XML);
        return extensionXmls.isEmpty() ? null : extensionXmls.get(0).toString();
    }

    public String parseDefaultInputMediaType(DialectDomainElement element) {
        List defaultInputMediaTypes = element.getScalarByPropertyUri(DEFAULT_INPUT_MEDIA_TYPE);
        return defaultInputMediaTypes.isEmpty() ? null : defaultInputMediaTypes.get(0).toString();
    }

    public String parseDefaultOutputMediaType(DialectDomainElement element) {
        List defaultOutputMediaTypes = element.getScalarByPropertyUri(DEFAULT_OUTPUT_MEDIA_TYPE);
        return defaultOutputMediaTypes.isEmpty() ? null : defaultOutputMediaTypes.get(0).toString();
    }

    public Boolean parseSkipOutputTypeValidation(DialectDomainElement element) {
        List skipOutputTypeValidations = element.getScalarByPropertyUri(SKIP_OUTPUT_TYPE_VALIDATION);
        return skipOutputTypeValidations.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(skipOutputTypeValidations.get(0).toString()));
    }
}

