/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.mule.connectivity.restconnect.internal.descriptor.model.InPaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OutPaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.ResponseValueExtractionDescriptor;

public class DescriptorPaginationParser {
    private static final String AML_REST_CONNECT_PAGINATION_DECLARATIONS = "http://a.ml/vocabularies/restConnect#paginationDeclarations";
    private static final String AML_REST_CONNECT_PAGINATION_DECLARATION = "http://a.ml/vocabularies/core#name";
    private static final String AML_REST_CONNECT_PAGINATION_TYPE = "http://a.ml/vocabularies/restConnect#paginationType";
    private static final String AML_REST_CONNECT_PAGINATION_PARAMETERS = "http://a.ml/vocabularies/restConnect#paginationParameters";
    private static final String AML_REST_CONNECT_PAGINATION_OFFSET_PARAM_NAME = "http://a.ml/vocabularies/restConnect#offsetParamName";
    private static final String AML_REST_CONNECT_PAGINATION_INITIAL_OFFSET = "http://a.ml/vocabularies/restConnect#initialOffset";
    private static final String AML_REST_CONNECT_PAGINATION_NEXT_TOKEN_PARAM_NAME = "http://a.ml/vocabularies/restConnect#nextTokenParamName";
    private static final String AML_REST_CONNECT_PAGINATION_NEXT_TOKEN_EXPRESSION = "http://a.ml/vocabularies/restConnect#nextTokenExpression";
    private static final String AML_REST_CONNECT_PAGINATION_PAGE_NUMBER_PARAM_NAME = "http://a.ml/vocabularies/restConnect#pageNumberParamName";
    private static final String AML_REST_CONNECT_PAGINATION_INITIAL_PAGE_NUMBER = "http://a.ml/vocabularies/restConnect#initialPageNumber";
    private static final String AML_REST_CONNECT_PAGINATION_PAGING_RESPONSE_EXPRESSION = "http://a.ml/vocabularies/restConnect#pagingResponseExpression";
    private static final String AML_REST_CONNECT_EXPRESSION_LANGUAGE = "http://a.ml/vocabularies/restConnect#expressionLanguage";
    private static final String AML_REST_CONNECT_EXPRESSION_CONTENT = "http://a.ml/vocabularies/restConnect#expressionContent";

    private DescriptorPaginationParser() {
    }

    public static List<PaginationDeclarationDescriptor> parsePaginationsDescription(DialectDomainElement encodes) {
        List paginationsDescriptor = encodes.getObjectPropertyUri(AML_REST_CONNECT_PAGINATION_DECLARATIONS);
        return paginationsDescriptor.isEmpty() ? Collections.emptyList() : DescriptorPaginationParser.getPagingMethods(paginationsDescriptor);
    }

    private static List<PaginationDeclarationDescriptor> getPagingMethods(List<DialectDomainElement> paginationsDescriptor) {
        ArrayList<PaginationDeclarationDescriptor> paginationDeclarationDescriptors = new ArrayList<PaginationDeclarationDescriptor>(paginationsDescriptor.size());
        for (DialectDomainElement endpointsElement : paginationsDescriptor) {
            String pagingStrategyName = DescriptorPaginationParser.parsePagingStrategyName(endpointsElement);
            String pagingType = DescriptorPaginationParser.parsePagingType(endpointsElement);
            List parameters = endpointsElement.getObjectPropertyUri(AML_REST_CONNECT_PAGINATION_PARAMETERS);
            ArrayList<PaginationParameterDescriptor> paginationParameterDescriptors = new ArrayList<PaginationParameterDescriptor>(parameters.size());
            if (!parameters.isEmpty()) {
                InPaginationParameterDescriptor pagingResponseExpression;
                OutPaginationParameterDescriptor initialPageNumber;
                OutPaginationParameterDescriptor pageNumberParamName;
                InPaginationParameterDescriptor nextTokenExpression;
                OutPaginationParameterDescriptor nextTokenParamName;
                OutPaginationParameterDescriptor initialOffsetDescriptor;
                DialectDomainElement pagingParameterItem = (DialectDomainElement)parameters.get(0);
                OutPaginationParameterDescriptor offsetParamNameDescriptor = DescriptorPaginationParser.parseOffsetParamName(pagingParameterItem);
                if (offsetParamNameDescriptor != null) {
                    paginationParameterDescriptors.add(offsetParamNameDescriptor);
                }
                if ((initialOffsetDescriptor = DescriptorPaginationParser.parseInitialOffset(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(initialOffsetDescriptor);
                }
                if ((nextTokenParamName = DescriptorPaginationParser.parseNextTokenParamName(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(nextTokenParamName);
                }
                if ((nextTokenExpression = DescriptorPaginationParser.parseNextTokenExpression(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(nextTokenExpression);
                }
                if ((pageNumberParamName = DescriptorPaginationParser.parsePageNumberParamName(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(pageNumberParamName);
                }
                if ((initialPageNumber = DescriptorPaginationParser.parseInitialPageNumber(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(initialPageNumber);
                }
                if ((pagingResponseExpression = DescriptorPaginationParser.parsePagingResponseExpression(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(pagingResponseExpression);
                }
            }
            paginationDeclarationDescriptors.add(new PaginationDeclarationDescriptor(pagingStrategyName, pagingType, paginationParameterDescriptors));
        }
        return paginationDeclarationDescriptors;
    }

    private static OutPaginationParameterDescriptor parseOffsetParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List offsetParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_OFFSET_PARAM_NAME);
        return offsetParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("offsetParamName", offsetParamName.get(0).toString());
    }

    private static OutPaginationParameterDescriptor parseInitialOffset(@NotNull DialectDomainElement pagingParameterItem) {
        List initialOffset = pagingParameterItem.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_INITIAL_OFFSET);
        return initialOffset.isEmpty() ? null : new OutPaginationParameterDescriptor("initialOffset", initialOffset.get(0).toString());
    }

    private static OutPaginationParameterDescriptor parseNextTokenParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List nextTokenParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_NEXT_TOKEN_PARAM_NAME);
        return nextTokenParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("nextTokenParamName", nextTokenParamName.get(0).toString());
    }

    private static OutPaginationParameterDescriptor parsePageNumberParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List pageNumberParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_PAGE_NUMBER_PARAM_NAME);
        return pageNumberParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("pageNumberParamName", pageNumberParamName.get(0).toString());
    }

    private static OutPaginationParameterDescriptor parseInitialPageNumber(@NotNull DialectDomainElement pagingParameterItem) {
        List initialPageNumber = pagingParameterItem.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_INITIAL_PAGE_NUMBER);
        return initialPageNumber.isEmpty() ? null : new OutPaginationParameterDescriptor("initialPageNumber", initialPageNumber.get(0).toString());
    }

    private static InPaginationParameterDescriptor parseNextTokenExpression(@NotNull DialectDomainElement pagingParameterItem) {
        List nextTokenExpression = pagingParameterItem.getObjectPropertyUri(AML_REST_CONNECT_PAGINATION_NEXT_TOKEN_EXPRESSION);
        ResponseValueExtractionDescriptor responseValueExtractionDescriptor = DescriptorPaginationParser.parseResponseValueExtractionDescriptor(nextTokenExpression);
        return responseValueExtractionDescriptor == null ? null : new InPaginationParameterDescriptor("nextTokenExpression", responseValueExtractionDescriptor);
    }

    private static InPaginationParameterDescriptor parsePagingResponseExpression(@NotNull DialectDomainElement pagingParameterItem) {
        List pagingResponseExpression = pagingParameterItem.getObjectPropertyUri(AML_REST_CONNECT_PAGINATION_PAGING_RESPONSE_EXPRESSION);
        ResponseValueExtractionDescriptor responseValueExtractionDescriptor = DescriptorPaginationParser.parseResponseValueExtractionDescriptor(pagingResponseExpression);
        return responseValueExtractionDescriptor == null ? null : new InPaginationParameterDescriptor("pagingResponseExpression", responseValueExtractionDescriptor);
    }

    private static String parsePagingStrategyName(@NotNull DialectDomainElement endpointsElement) {
        List pagingStrategyNames = endpointsElement.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_DECLARATION);
        return pagingStrategyNames.isEmpty() ? null : pagingStrategyNames.get(0).toString();
    }

    private static String parsePagingType(@NotNull DialectDomainElement endpointsElement) {
        List pagingTypes = endpointsElement.getScalarByPropertyUri(AML_REST_CONNECT_PAGINATION_TYPE);
        return pagingTypes.isEmpty() ? null : pagingTypes.get(0).toString();
    }

    private static ResponseValueExtractionDescriptor parseResponseValueExtractionDescriptor(List<DialectDomainElement> valueExtraction) {
        if (!valueExtraction.isEmpty()) {
            return new ResponseValueExtractionDescriptor(DescriptorPaginationParser.parseExpressionLanguage(valueExtraction.get(0)), DescriptorPaginationParser.parseExpressionContent(valueExtraction.get(0)));
        }
        return null;
    }

    private static String parseExpressionLanguage(@NotNull DialectDomainElement endpointsElement) {
        List expressionLanguage = endpointsElement.getScalarByPropertyUri(AML_REST_CONNECT_EXPRESSION_LANGUAGE);
        return expressionLanguage.isEmpty() ? null : expressionLanguage.get(0).toString();
    }

    private static String parseExpressionContent(@NotNull DialectDomainElement endpointsElement) {
        List expressionContent = endpointsElement.getScalarByPropertyUri(AML_REST_CONNECT_EXPRESSION_CONTENT);
        return expressionContent.isEmpty() ? null : expressionContent.get(0).toString();
    }
}

