/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;

public final class DescriptorParserUtils {
    private static final String CORE_NAME = "http://a.ml/vocabularies/core#name";
    private static final String CORE_DESCRIPTION = "http://a.ml/vocabularies/core#description";
    private static final String REST_CONNECT_IGNORE = "http://a.ml/vocabularies/restConnect#ignore";
    private static final String REST_CONNECT_BASE_URI_REFERENCE = "http://a.ml/vocabularies/restConnect#baseUriReference";

    private DescriptorParserUtils() {
    }

    public static boolean parseRestConnectIgnored(DialectDomainElement element) {
        List ignores = element.getScalarByPropertyUri(REST_CONNECT_IGNORE);
        return !ignores.isEmpty() && Boolean.parseBoolean(ignores.get(0).toString());
    }

    public static String parseAlternativeBaseUri(DialectDomainElement element) {
        List urls = element.getScalarByPropertyUri(REST_CONNECT_BASE_URI_REFERENCE);
        return urls.isEmpty() ? null : urls.get(0).toString();
    }

    public static String parseElementCoreName(DialectDomainElement element) {
        List elementNames = element.getScalarByPropertyUri(CORE_NAME);
        return elementNames.isEmpty() ? null : elementNames.get(0).toString();
    }

    public static String parseElementCoreDescription(DialectDomainElement element) {
        List elementDescriptions = element.getScalarByPropertyUri(CORE_DESCRIPTION);
        return elementDescriptions.isEmpty() ? null : elementDescriptions.get(0).toString();
    }

    public static String getSchemaContent(Path descriptorDirectory, String inputSchemaPathString) throws ModelGenerationException {
        if (StringUtils.isBlank((CharSequence)inputSchemaPathString)) {
            return null;
        }
        Path schemaPath = descriptorDirectory.resolve(inputSchemaPathString);
        try {
            byte[] encoded = Files.readAllBytes(schemaPath);
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ModelGenerationException("Could not read schema file: " + schemaPath, e);
        }
    }
}

