/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.Pagination;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkContent;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkMtfOperationTest;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkOutputTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkPagingTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkParameter;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectors.restconnect.commons.api.configuration.RestConnectConfiguration;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.error.RequestErrorTypeProvider;
import org.mule.connectors.restconnect.commons.api.operation.BaseRestConnectOperation;
import org.mule.connectors.restconnect.commons.api.operation.ConfigurationOverrides;
import org.mule.connectors.restconnect.commons.api.operation.EntityRequestParameters;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.connectors.restconnect.commons.api.operation.NonEntityRequestParameters;
import org.mule.connectors.restconnect.commons.internal.RestConnectConstants;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public abstract class AbstractSdkOperation
extends JavaTemplateEntity {
    public static final String PARAM_DOC_NAME_DESCRIPTION = "@param $L $L\n";
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    public static final String ACCEPT_HEADER_NAME = "accept";
    public static final String ADD_QUERY_PARAM_METHOD_NAME = "addQueryParam";
    public static final String ADD_HEADER_METHOD_NAME = "addHeader";
    public static final String ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME = "queryParams";
    public static final String ADD_MULTIPLE_HEADER_METHOD_NAME = "headers";
    private static final String REQUEST_PARAMETERS_GROUP_NAME = "REQUEST_PARAMETERS_GROUP_NAME";
    private static final String CONNECTOR_OVERRIDES = "CONNECTOR_OVERRIDES";
    private final ConnectorOperation operation;
    protected final List<SdkParameter> allPathParameters;
    protected final List<SdkParameter> allQueryParameters;
    protected final List<SdkParameter> allHeaders;
    protected final SdkContent content;
    protected final SdkOutputTypeResolver outputTypeResolver;
    private final SdkMtfOperationTest sdkMtfOperationTest;

    public abstract FieldSpec generateExpressionLanguageField();

    public abstract ParameterSpec generateInitialPagingParameter();

    public abstract TypeName generateMethodReturn();

    public abstract CodeBlock generateOperationMethodBody();

    public AbstractSdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        super(outputDir, connectorModel);
        this.operation = operation;
        this.allPathParameters = operation.getUriParameters().stream().map(x -> new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), (Parameter)x)).collect(Collectors.toList());
        this.allQueryParameters = operation.getQueryParameters().stream().map(x -> new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), (Parameter)x)).collect(Collectors.toList());
        this.allHeaders = operation.getHeaders().stream().map(x -> new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), (Parameter)x)).collect(Collectors.toList());
        this.content = this.buildContent(outputDir, connectorModel, sdkConnector, operation);
        this.outputTypeResolver = this.buildOutputTypeResolver(sdkConnector);
        this.sdkMtfOperationTest = new SdkMtfOperationTest(operation, outputDir);
    }

    private SdkOutputTypeResolver buildOutputTypeResolver(SdkConnector sdkConnector) throws TemplatingException {
        if (this.operation.getOutputMetadata() == null) {
            return null;
        }
        if (this.operation.hasPagination()) {
            return new SdkPagingTypeResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation, this.operation.getOutputMetadata());
        }
        return new SdkOutputTypeResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation, this.operation.getOutputMetadata());
    }

    protected SdkContent buildContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        return operation.getInputMetadata() != null ? new SdkContent(outputDir, connectorModel, sdkConnector, operation) : null;
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml(this.operation.getInternalName()) + "Operation";
    }

    private String getJavaMethodName() {
        return JavaUtils.getJavaLowerCamelNameFromXml(this.operation.getInternalName());
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.operation";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.content != null) {
            this.content.applyTemplates();
        }
        if (this.outputTypeResolver != null) {
            this.outputTypeResolver.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allPathParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allQueryParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allHeaders) {
            sdkParameter.applyTemplates();
        }
        this.sdkMtfOperationTest.applyTemplates();
        this.generateOperationClass();
    }

    protected void generateOperationClass() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BaseRestConnectOperation.class).addMethod(this.generateOperationMethod());
        FieldSpec expressionLanguage = this.generateExpressionLanguageField();
        if (expressionLanguage != null) {
            operationClassBuilder.addField(expressionLanguage);
        }
        for (SdkParameter pathParam : this.allPathParameters) {
            operationClassBuilder.addField(this.generatePathParamPatternField(pathParam));
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getPackage(), (TypeSpec)operationClassBuilder.build()).addStaticImport(RestConnectConstants.class, new String[]{REQUEST_PARAMETERS_GROUP_NAME, CONNECTOR_OVERRIDES});
        if (!this.allPathParameters.isEmpty()) {
            javaFileBuilder.addStaticImport(Pattern.class, new String[]{"compile"});
        }
        this.writeClassToFile(javaFileBuilder.build());
    }

    private FieldSpec generatePathParamPatternField(SdkParameter pathParam) {
        return FieldSpec.builder(Pattern.class, (String)this.getPathParamPatternFieldName(pathParam), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("compile(\"\\\\{$L}\")", new Object[]{pathParam.getExternalName()}).build();
    }

    private String getPathParamPatternFieldName(SdkParameter pathParam) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, pathParam.getJavaName()) + "_PATTERN";
    }

    private AnnotationSpec generateDescriptionAnnotation() {
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText(this.operation.getDescription())}).build();
    }

    public MethodSpec generateOperationMethod() {
        ParameterSpec parameterSpec;
        CodeBlock.Builder javaDoc = CodeBlock.builder().add("\n$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.operation.getDescription(), (CharSequence)this.operation.getDisplayName())}).add("\nThis operation makes an HTTP $L request to the $L endpoint", new Object[]{this.operation.getHttpMethod().toUpperCase(), this.operation.getPath()}).add("\n", new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterSpec configParameter = this.generateConfigParameter();
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configParameter.name, "the configuration to use"});
        methodBuilder.addParameter(configParameter);
        if (this.requiresConnectionParameter()) {
            ParameterSpec connectionParameter = this.generateConnectionParameter();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{connectionParameter.name, "the connection to use"});
            methodBuilder.addParameter(connectionParameter);
        }
        for (SdkParameter sdkParam : this.allPathParameters) {
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        for (SdkParameter sdkParam : this.allQueryParameters) {
            if (this.isQueryParamDefinedInPagination(sdkParam.getExternalName())) continue;
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        for (SdkParameter sdkParam : this.allHeaders) {
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        ParameterSpec initialPagingParameter = this.generateInitialPagingParameter();
        if (initialPagingParameter != null) {
            methodBuilder.addParameter(initialPagingParameter);
            Optional<AnnotationSpec> summary = initialPagingParameter.annotations.stream().filter(x -> x.members.containsKey("value")).findFirst();
            if (summary.isPresent()) {
                javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{initialPagingParameter.name, ((CodeBlock)((List)summary.get().members.get("value")).get(0)).toString().replaceAll("\"", "")});
            }
        }
        this.addContentParameters(javaDoc, methodBuilder);
        ParameterSpec parameterSpec2 = this.generateRequestParametersParameter();
        methodBuilder.addParameter(parameterSpec2);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec2.name, "the {@link " + ((ClassName)parameterSpec2.type).simpleName() + "}"});
        ParameterSpec configurationOverridesParameter = this.generateConfigurationOverridesParameter();
        methodBuilder.addParameter(configurationOverridesParameter);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configurationOverridesParameter.name, "the {@link ConfigurationOverrides}"});
        ParameterSpec streamingHelperParameter = this.generateStreamingHelperParameter();
        methodBuilder.addParameter(streamingHelperParameter);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{streamingHelperParameter.name, "the {@link StreamingHelper}"});
        if (this.requiresCallbackParameter()) {
            ParameterSpec completionCallbackParameter = this.generateCompletionCallbackParameter();
            methodBuilder.addParameter(completionCallbackParameter);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{completionCallbackParameter.name, "the operation's {@link CompletionCallback}"});
        }
        methodBuilder.addAnnotation(this.generateThrowsAnnotation());
        methodBuilder.addAnnotation(this.generateDisplayNameAnnotation());
        if (StringUtils.isNotBlank((CharSequence)this.operation.getDescription())) {
            methodBuilder.addAnnotation(this.generateDescriptionAnnotation());
        }
        if (this.requiresMediaTypeAnnotation()) {
            if (this.operation.getOutputMetadata() != null) {
                methodBuilder.addAnnotation(this.generateMediaTypeAnnotation());
            } else {
                methodBuilder.addAnnotation(this.generateDefaultMediaTypeAnnotation());
            }
        }
        if (this.outputTypeResolver != null && this.outputTypeResolver.getRequiresTypeResolver()) {
            methodBuilder.addAnnotation(this.outputTypeResolver.getOutputTypeResolverAnnotation());
        }
        methodBuilder.addCode(this.generateOperationMethodBody());
        methodBuilder.addJavadoc(javaDoc.build());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    protected void addContentParameters(CodeBlock.Builder javaDoc, MethodSpec.Builder methodBuilder) {
        if (this.content != null) {
            ParameterSpec parameterSpec = this.content.generateContentParameter();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "the content to use"});
        }
    }

    private boolean isQueryParamDefinedInPagination(String paramName) {
        Pagination pagination = this.connectorModel.getPagination(this.operation.getPagination());
        if (pagination != null) {
            return pagination.containsParameterExternalName(paramName);
        }
        return false;
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.operation.getDisplayName()}).build();
    }

    public CodeBlock.Builder generateCommonOperationMethodBody() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        methodBody.addStatement("$T requestPath = $S", new Object[]{String.class, this.operation.getPath()});
        for (SdkParameter pathParam : this.allPathParameters) {
            if (pathParam.isArrayType()) {
                methodBody.addStatement("requestPath = $L.matcher(requestPath).replaceAll($L.stream().map(v -> $L).collect($T.joining(\",\")))", new Object[]{this.getPathParamPatternFieldName(pathParam), pathParam.getJavaName(), pathParam.getStringValueGetter("v"), Collectors.class});
                continue;
            }
            methodBody.addStatement("requestPath = $L.matcher(requestPath).replaceAll($L)", new Object[]{this.getPathParamPatternFieldName(pathParam), pathParam.getStringValueGetter()});
        }
        String baseUriString = "connection.getBaseUri()";
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlternativeBaseUri()) && this.connectorModel.getBaseUri().isMultipleBaseUri()) {
            String multipleBaseUri = this.connectorModel.getBaseUri().getMultipleBaseUriOrDefault(this.operation.getAlternativeBaseUri());
            baseUriString = "\"" + multipleBaseUri + "\"";
        }
        methodBody.addStatement("$T builder = requestBuilder($L, requestPath, $T.$L, parameters)", new Object[]{HttpRequestBuilder.class, baseUriString, HttpConstants.Method.class, this.operation.getHttpMethod().toUpperCase()});
        if (this.operation.getInputMetadata() != null && this.operation.getInputMetadata().getMediaType() != null) {
            String mediaType = this.operation.getInputMetadata().getMediaType().toString();
            if (this.operation.getInputMetadata().getMediaType().equals((Object)javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
                mediaType = mediaType + "; boundary=__rc2_34b212";
            }
            methodBody.addStatement("builder.$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, CONTENT_TYPE_HEADER_NAME, mediaType});
        }
        if (this.operation.getOutputMetadata() != null && this.operation.getOutputMetadata().getMediaType() != null) {
            methodBody.addStatement("builder.$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, ACCEPT_HEADER_NAME, this.operation.getOutputMetadata().getMediaType().toString()});
        }
        for (SdkParameter queryParam : this.allQueryParameters) {
            if (this.isQueryParamDefinedInPagination(queryParam.getExternalName())) continue;
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(queryParam, ADD_QUERY_PARAM_METHOD_NAME, ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME));
        }
        for (SdkParameter header : this.allHeaders) {
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(header, ADD_HEADER_METHOD_NAME, ADD_MULTIPLE_HEADER_METHOD_NAME));
        }
        this.addSetBodyMethod(methodBody);
        return methodBody;
    }

    protected void addSetBodyMethod(CodeBlock.Builder methodBody) {
        if (this.content != null) {
            methodBody.addStatement("setBody(builder, content, overrides.getStreamingType())", new Object[0]);
        }
    }

    private CodeBlock generateRequestBuilderParameterCodeBlock(SdkParameter parameter, String addSingleValueMethodName, String addMultipleValueMethodName) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (parameter.isArrayType()) {
            builder.addStatement("$T<$T, $T> $LParams = new $T<>()", new Object[]{MultiMap.class, String.class, String.class, parameter.getJavaName(), MultiMap.class});
            builder.addStatement("$L.stream().filter(v -> v != null).forEach(v -> $LParams.put($S, $L))", new Object[]{parameter.getJavaName(), parameter.getJavaName(), parameter.getExternalName(), parameter.getStringValueGetter("v")});
            builder.addStatement("builder.$L($LParams)", new Object[]{addMultipleValueMethodName, parameter.getJavaName()});
        } else {
            if (parameter.isNullable()) {
                builder.beginControlFlow("if ($L != null)", new Object[]{parameter.getJavaName()});
            }
            builder.addStatement("builder.$L($S, $L)", new Object[]{addSingleValueMethodName, parameter.getExternalName(), parameter.getStringValueGetter()});
            if (parameter.isNullable()) {
                builder.endControlFlow();
            }
        }
        return builder.build();
    }

    private AnnotationSpec generateThrowsAnnotation() {
        return AnnotationSpec.builder(Throws.class).addMember("value", "$T.class", new Object[]{RequestErrorTypeProvider.class}).build();
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operation.getOutputMetadata().getMediaType()}).build();
    }

    private AnnotationSpec generateDefaultMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operationMethodRequiresBody() ? "application/json" : "text/plain"}).build();
    }

    private ParameterSpec generateConfigParameter() {
        return ParameterSpec.builder(RestConnectConfiguration.class, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(Config.class).build();
    }

    private ParameterSpec generateConnectionParameter() {
        return ParameterSpec.builder(RestConnection.class, (String)"connection", (Modifier[])new Modifier[0]).addAnnotation(Connection.class).build();
    }

    private ParameterSpec generateRequestParametersParameter() {
        AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", REQUEST_PARAMETERS_GROUP_NAME, new Object[0]).build();
        Class requestParameterClass = this.operation.getInputMetadata() != null ? EntityRequestParameters.class : NonEntityRequestParameters.class;
        return ParameterSpec.builder(requestParameterClass, (String)"parameters", (Modifier[])new Modifier[0]).addAnnotation(parameterGroupAnnotation).build();
    }

    private ParameterSpec generateConfigurationOverridesParameter() {
        AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", CONNECTOR_OVERRIDES, new Object[0]).build();
        return ParameterSpec.builder(ConfigurationOverrides.class, (String)"overrides", (Modifier[])new Modifier[0]).addAnnotation(parameterGroupAnnotation).build();
    }

    private ParameterSpec generateStreamingHelperParameter() {
        return ParameterSpec.builder(StreamingHelper.class, (String)"streamingHelper", (Modifier[])new Modifier[0]).build();
    }

    private ParameterSpec generateCompletionCallbackParameter() {
        if (!this.isVoidOperation() && (this.outputTypeResolver != null || this.operationMethodRequiresBody())) {
            return ParameterSpec.builder((TypeName)ParameterizedTypeName.get(CompletionCallback.class, (Type[])new Type[]{InputStream.class, HttpResponseAttributes.class}), (String)"callback", (Modifier[])new Modifier[0]).build();
        }
        return ParameterSpec.builder((TypeName)ParameterizedTypeName.get(CompletionCallback.class, (Type[])new Type[]{String.class, HttpResponseAttributes.class}), (String)"callback", (Modifier[])new Modifier[0]).build();
    }

    protected boolean operationMethodRequiresBody() {
        return this.operation.getHttpMethod().equalsIgnoreCase("get") || this.operation.getHttpMethod().equalsIgnoreCase("post") || this.operation.getHttpMethod().equalsIgnoreCase("patch") || this.operation.getHttpMethod().equalsIgnoreCase("options");
    }

    protected boolean isVoidOperation() {
        return this.operation.getVoidOperation() != null && this.operation.getVoidOperation() != false;
    }

    protected boolean requiresConnectionParameter() {
        return true;
    }

    protected boolean requiresCallbackParameter() {
        return true;
    }

    protected boolean requiresMediaTypeAnnotation() {
        return true;
    }
}

