/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.BooleanOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.DateOnlyOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.DateTimeOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.FileOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.FromJsonOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.IntegerOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.JsonOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.NumberOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.StringOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.TimeOnlyOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.XmlOutputTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;

public class SdkOutputTypeResolver
extends SdkAbstractStaticTypeResolver {
    private String qName;

    public SdkOutputTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, FileGenerationUtils.SchemaNameType.OUTPUT, "");
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveTypeResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlOutputTypeResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return JsonOutputTypeResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return FromJsonOutputTypeResolver.class;
        }
        return StringOutputTypeResolver.class;
    }

    protected Class<?> getPrimitiveTypeResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
            return DateTimeOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyOutputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileOutputTypeResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    public AnnotationSpec getOutputTypeResolverAnnotation() {
        return AnnotationSpec.builder(OutputResolver.class).addMember("output", "$T.class", new Object[]{ClassName.get((String)this.getPackage(), (String)this.getClassName(), (String[])new String[0])}).build();
    }

    @Override
    protected String getClassNameSuffix() {
        return "OutputTypeResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlOutputTypeResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonOutputTypeResolver.class) || this.superclass.equals(FileOutputTypeResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonOutputTypeResolver.class) || this.superclass.equals(JsonOutputTypeResolver.class) || this.superclass.equals(XmlOutputTypeResolver.class);
    }
}

