/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.validation.rules.AtLeastOneSupportedSecuritySchemeRule;
import org.mule.connectivity.restconnect.internal.validation.rules.BaseJavaPackageMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ConnectorNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorInputMediaTypeMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorOperationMustExistInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorOtputMediaTypeMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorParameterMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorPathMustExistInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorRedundantOutputDefinitionRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ExtensionXmlMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavArtifactIdMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavGroupIdMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavVersionMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoDefaultInputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoDefaultOutputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoInputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoOutputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NotSupportedSecuritySchemeRule;
import org.mule.connectivity.restconnect.internal.validation.rules.OperationMustDeclareResponseBodyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.OperationNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ParameterNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class ModelValidator {
    private static List<ValidationRule> allRules = new LinkedList<ValidationRule>();
    private List<ValidationRule> validationRules;

    public static ModelValidator defaultModelValidator() {
        return new ModelValidator(allRules);
    }

    public ModelValidator(List<ValidationRule> rules) {
        this.validationRules = rules;
    }

    public List<ValidationResult> preValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        return this.validationRules.stream().flatMap(x -> x.preValidate(connectorDescriptor, apiModel).stream()).collect(Collectors.toList());
    }

    public List<ValidationResult> postValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModel connectorModel) {
        return this.validationRules.stream().flatMap(x -> x.postValidate(connectorDescriptor, apiModel, connectorModel).stream()).collect(Collectors.toList());
    }

    static {
        allRules.add(new DescriptorPathMustExistInApiRule());
        allRules.add(new DescriptorOperationMustExistInApiRule());
        allRules.add(new OperationMustDeclareResponseBodyRule());
        allRules.add(new AtLeastOneSupportedSecuritySchemeRule());
        allRules.add(new ExtensionXmlMustBeValidRule());
        allRules.add(new BaseJavaPackageMustBeValidRule());
        allRules.add(new GavGroupIdMustBeValidRule());
        allRules.add(new GavArtifactIdMustBeValidRule());
        allRules.add(new GavVersionMustBeValidRule());
        allRules.add(new NotSupportedSecuritySchemeRule());
        allRules.add(new ConnectorNameMustBeFriendlyRule());
        allRules.add(new OperationNameMustBeFriendlyRule());
        allRules.add(new ParameterNameMustBeFriendlyRule());
        allRules.add(new NoDefaultInputMediaTypeDefinedRule());
        allRules.add(new NoDefaultOutputMediaTypeDefinedRule());
        allRules.add(new DescriptorParameterMustBePresentInApiRule());
        allRules.add(new NoInputMediaTypeDefinedRule());
        allRules.add(new DescriptorInputMediaTypeMustBePresentInApiRule());
        allRules.add(new NoOutputMediaTypeDefinedRule());
        allRules.add(new DescriptorOtputMediaTypeMustBePresentInApiRule());
        allRules.add(new DescriptorRedundantOutputDefinitionRule());
    }
}

