/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.ApiKeySettings;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.SecurityScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.security.AMFOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.security.AMFSecuritySchemesNaming;

public class AMFSecuritySchemeModel
extends APISecuritySchemeModel {
    private final SecurityScheme securityScheme;

    public AMFSecuritySchemeModel(SecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
        this.name = securityScheme.name().value();
        this.securitySchemeClass = this.buildSecuritySchemeClass();
        this.customHeaders = this.buildCustomHeadersModel();
        this.customQueryParams = this.buildCustomQueryParamsModel();
        this.accessTokenUri = this.buildAccessTokenUri();
        this.authorizationUri = this.buildAuthorizationUri();
        this.scopes = this.buildScopes();
    }

    private String buildAccessTokenUri() {
        OAuth2Settings oAuth2Settings;
        if (this.securityScheme.settings() instanceof OAuth2Settings && (oAuth2Settings = (OAuth2Settings)this.securityScheme.settings()) != null) {
            return oAuth2Settings.accessTokenUri().value();
        }
        return null;
    }

    private String buildAuthorizationUri() {
        OAuth2Settings oAuth2Settings;
        if (this.securityScheme.settings() instanceof OAuth2Settings && (oAuth2Settings = (OAuth2Settings)this.securityScheme.settings()) != null) {
            return oAuth2Settings.authorizationUri().value();
        }
        return null;
    }

    private List<String> buildScopes() {
        OAuth2Settings oAuth2Settings;
        if (this.securityScheme.settings() instanceof OAuth2Settings && (oAuth2Settings = (OAuth2Settings)this.securityScheme.settings()) != null) {
            return oAuth2Settings.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Class<? extends ConnectorSecurityScheme> buildSecuritySchemeClass() {
        String schemeType = this.securityScheme.type().value();
        if (AMFSecuritySchemesNaming.isBasicAuth(schemeType)) {
            return BasicAuthScheme.class;
        }
        if (AMFSecuritySchemesNaming.isPassThrough(schemeType)) {
            return PassThroughScheme.class;
        }
        if (AMFSecuritySchemesNaming.isApiKey(schemeType)) {
            return PassThroughScheme.class;
        }
        if (AMFSecuritySchemesNaming.isOauth2(schemeType)) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)this.securityScheme.settings();
            if (AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings)) {
                return OAuth2AuthorizationCodeScheme.class;
            }
            if (AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings)) {
                return OAuth2ClientCredentialsScheme.class;
            }
        } else {
            if (AMFSecuritySchemesNaming.isDigest(schemeType)) {
                return DigestAuthenticationScheme.class;
            }
            if (AMFSecuritySchemesNaming.isCustom(schemeType)) {
                return CustomAuthenticationScheme.class;
            }
        }
        return NotSupportedScheme.class;
    }

    private List<APIParameterModel> buildCustomQueryParamsModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : this.securityScheme.queryParameters()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.QUERY, false);
            list.add(parameterModel);
        }
        AMFParameterModel queryParam = this.getApiKeyParameter("query");
        if (queryParam != null) {
            list.add(queryParam);
        }
        return list;
    }

    private List<APIParameterModel> buildCustomHeadersModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        for (Parameter x : this.securityScheme.headers()) {
            AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.HEADER, false);
            list.add(parameterModel);
        }
        AMFParameterModel header = this.getApiKeyParameter("header");
        if (header != null) {
            list.add(header);
        }
        return list;
    }

    private AMFParameterModel getApiKeyParameter(String from) {
        if (this.securityScheme.settings() instanceof ApiKeySettings) {
            String in = ((ApiKeySettings)this.securityScheme.settings()).in().value();
            String name = ((ApiKeySettings)this.securityScheme.settings()).name().value();
            String string = name = StringUtils.isNotBlank((CharSequence)name) ? name : "api-key";
            if (in.equalsIgnoreCase(from)) {
                return new AMFParameterModel(name, ParameterType.SECURITY, new AMFPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType.STRING));
            }
        }
        return null;
    }
}

