/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.resourceloader.RPExchangeDependencyResourceLoader;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.util.RPOperationMappingUtils;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;

public class RPAPIModel
extends APIModel {
    private final Api api;

    public RPAPIModel(File apiSpec, String rootDir, SpecFormat specFormat, boolean skipValidations) throws ModelGenerationException {
        if (!specFormat.equals((Object)SpecFormat.RAML)) {
            throw new IllegalArgumentException("RamlParser does not support " + specFormat.getName() + " format");
        }
        this.api = this.getAPIFromRamlFile(apiSpec, rootDir, skipValidations);
        this.apiName = this.buildApiName();
        this.description = this.buildDescription();
        this.protocols = this.buildProtocols();
        this.baseUri = this.buildBaseUri(this.protocols);
        this.operationsModel = this.buildOperationsModel();
    }

    private BaseUri buildBaseUri(List<Protocol> supportedProtocols) {
        String apiVersion = this.api.version() != null ? this.api.version().value() : null;
        String baseUriString = this.api.baseUri() != null ? this.api.baseUri().value() : null;
        return new BaseUri(baseUriString, apiVersion, supportedProtocols);
    }

    private String buildDescription() {
        return this.api.description() != null ? this.api.description().value() : "";
    }

    private String buildApiName() {
        return this.api.title() != null ? this.api.title().value() : "";
    }

    private List<Protocol> buildProtocols() {
        return this.api.protocols().stream().map(Protocol::getFromString).collect(Collectors.toList());
    }

    private List<APIOperationModel> buildOperationsModel() throws ModelGenerationException {
        ArrayList<APIOperationModel> operationsModel = new ArrayList<APIOperationModel>();
        for (Method method : RPOperationMappingUtils.getMethods(this.api)) {
            operationsModel.add(new RPOperationModel(this.api, method));
        }
        return operationsModel;
    }

    private Api getAPIFromRamlFile(File raml, String rootDir, boolean skipValidations) throws InvalidSourceException {
        RamlModelResult ramlModelResult;
        CompositeResourceLoader custom = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new RPExchangeDependencyResourceLoader(rootDir)});
        RamlModelBuilder ramlModelBuilder = new RamlModelBuilder((ResourceLoader)custom);
        try {
            ramlModelResult = ramlModelBuilder.buildApi(raml);
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid RAML: Error in RAML Parser: " + e.getMessage() + ".", e);
        }
        if (!skipValidations && ramlModelResult.hasErrors()) {
            String ramlErrors = StringUtils.join((Iterable)ramlModelResult.getValidationResults(), (String)", ");
            throw new InvalidSourceException("Invalid RAML: " + ramlErrors + ".");
        }
        if (ramlModelResult.isVersion08()) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        if (ramlModelResult.getApiV10() == null) {
            throw new InvalidSourceException("Invalid RAML: the provided source isn't an API definition but a fragment.");
        }
        return ramlModelResult.getApiV10();
    }
}

