/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.api;

public enum Parser {

  RAML_PARSER("RAMLParser"), AMF("AMF");

  private String name;

  Parser(String name) {
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public static Parser getFromString(String parserName) {
    if (parserName.equalsIgnoreCase(RAML_PARSER.name)) {
      return RAML_PARSER;
    }
    if (parserName.equalsIgnoreCase(AMF.name)) {
      return AMF;
    }

    throw new IllegalArgumentException("Parser " + parserName + " does not exist. (RAMLParser & AMF)");
  }

}
