/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

public enum HTTPMethod {
    GET,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS,
    HEAD;


    public String getVerbName() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "CREATE";
            }
            case PUT: {
                return "UPDATE";
            }
            case PATCH: {
                return "PATCH";
            }
            case DELETE: {
                return "DELETE";
            }
            case OPTIONS: {
                return "GET_OPTIONS";
            }
            case HEAD: {
                return "GET_HEAD";
            }
        }
        throw new IllegalArgumentException("Unsupported method.");
    }

    public static HTTPMethod fromString(String method) {
        for (HTTPMethod httpMethod : HTTPMethod.values()) {
            if (!method.equalsIgnoreCase(httpMethod.name())) continue;
            return httpMethod;
        }
        throw new IllegalArgumentException("Action '" + method + "' should be a get / post / put / patch / delete / options / head operation.");
    }
}

