/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.QueryParamArrayFormat;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorParameterBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorSecuritySchemeBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PartDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;

public class ConnectorOperationBuilder {
    private final ConnectorTypeDefinitionBuilder typeDefinitionBuilder;
    private final ConnectorParameterBuilder parameterBuilder;
    private final ConnectorSecuritySchemeBuilder securitySchemeBuilder;

    public ConnectorOperationBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeDefinitionBuilder = new ConnectorTypeDefinitionBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this.typeDefinitionBuilder);
        this.securitySchemeBuilder = new ConnectorSecuritySchemeBuilder(this.typeDefinitionBuilder);
    }

    public List<ConnectorOperation> buildOperations(APIModel apiModel, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        ArrayList<ConnectorOperation> operations = new ArrayList<ConnectorOperation>();
        for (APIOperationModel op : apiModel.getOperationsModel()) {
            ConnectorOperation connectorOperation = this.buildOperation(op, ConnectorOperationBuilder.getEndpointDescriptor(op, connectorDescriptor), ConnectorOperationBuilder.getOperationDescriptor(op, connectorDescriptor), connectorDescriptor);
            if (connectorOperation == null) continue;
            operations.add(connectorOperation);
        }
        return operations;
    }

    private static EndPointDescriptor getEndpointDescriptor(APIOperationModel operationModel, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(operationModel.getPath())).findFirst().orElse(null);
    }

    private static OperationDescriptor getOperationDescriptor(APIOperationModel operationModel, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(operationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(operationModel.getHttpMethod().name())).findFirst().orElse(null);
    }

    public ConnectorOperation buildOperation(APIOperationModel apiOperationModel, EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        if (endPointDescriptor != null && endPointDescriptor.isIgnored()) {
            return null;
        }
        if (operationDescriptor != null && operationDescriptor.isIgnored()) {
            return null;
        }
        LinkedList<String> collisionNames = new LinkedList<String>();
        List<Parameter> uriParameters = this.parameterBuilder.buildParameterList(apiOperationModel.getUriParamsModel(), operationDescriptor, collisionNames);
        collisionNames.addAll(uriParameters.stream().map(Parameter::getInternalName).collect(Collectors.toList()));
        List<Parameter> queryParameters = this.parameterBuilder.buildParameterList(apiOperationModel.getQueryParamsModel(), operationDescriptor, collisionNames);
        collisionNames.addAll(queryParameters.stream().map(Parameter::getInternalName).collect(Collectors.toList()));
        List<Parameter> headers = this.parameterBuilder.buildParameterList(apiOperationModel.getHeadersModel(), operationDescriptor, collisionNames);
        return new ConnectorOperation(ConnectorOperationBuilder.buildOperationName(apiOperationModel, operationDescriptor), ConnectorOperationBuilder.buildOperationDescription(apiOperationModel, operationDescriptor), apiOperationModel.getPath(), apiOperationModel.getHttpMethod(), uriParameters, queryParameters, headers, this.buildInputTypeMetadata(apiOperationModel, operationDescriptor, connectorDescriptor), this.buildOutputTypeMetadata(apiOperationModel, operationDescriptor, connectorDescriptor), this.securitySchemeBuilder.buildSecuritySchemes(apiOperationModel.getSecuritySchemesModel(), connectorDescriptor.getSecurity()), ConnectorOperationBuilder.buildAlternativeBaseUri(endPointDescriptor, operationDescriptor), ConnectorOperationBuilder.buildPagination(operationDescriptor), ConnectorOperationBuilder.buildSkipOutputTypeValidation(operationDescriptor), ConnectorOperationBuilder.buildVoidOperation(operationDescriptor), this.buildQueryParamArrayFormat(connectorDescriptor, operationDescriptor));
    }

    protected QueryParamArrayFormat buildQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(operationDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return QueryParamArrayFormat.MULTIMAP;
    }

    private static Boolean buildSkipOutputTypeValidation(OperationDescriptor operationDescriptor) {
        return operationDescriptor != null ? operationDescriptor.getSkipOutputTypeValidation() : null;
    }

    private static Boolean buildVoidOperation(OperationDescriptor operationDescriptor) {
        return operationDescriptor != null ? operationDescriptor.getVoidOperation() : null;
    }

    private static String buildOperationName(APIOperationModel operationModel, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getName())) {
            return operationDescriptor.getName();
        }
        return operationModel.getName();
    }

    private static String buildOperationDescription(APIOperationModel operationModel, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getDescription())) {
            return operationDescriptor.getDescription();
        }
        return operationModel.getDescription();
    }

    private static String buildAlternativeBaseUri(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getBaseUri())) {
            return operationDescriptor.getBaseUri();
        }
        if (endPointDescriptor != null && StringUtils.isNotBlank((CharSequence)endPointDescriptor.getBaseUri())) {
            return endPointDescriptor.getBaseUri();
        }
        return null;
    }

    private static String buildPagination(OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination())) {
            return operationDescriptor.getPagination();
        }
        return null;
    }

    private TypeDefinition buildInputTypeMetadata(APIOperationModel apiOperationModel, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        String descriptorInputMediaType = "";
        String descriptorInputTypeSchema = "";
        List<PartDescriptor> partDescriptors = null;
        if (operationDescriptor != null) {
            descriptorInputMediaType = operationDescriptor.getInputMediaType();
            descriptorInputTypeSchema = operationDescriptor.getInputTypeSchema();
            partDescriptors = operationDescriptor.getExpects() != null ? operationDescriptor.getExpects().getPart() : null;
        }
        return this.buildIOTypeMetadata(apiOperationModel.getInputMetadataModel(), connectorDescriptor.getDefaultInputMediaType(), descriptorInputMediaType, descriptorInputTypeSchema, partDescriptors);
    }

    private TypeDefinition buildOutputTypeMetadata(APIOperationModel apiOperationModel, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        String descriptorOutputMediaType = "";
        String descriptorOutputTypeSchema = "";
        if (operationDescriptor != null) {
            descriptorOutputMediaType = operationDescriptor.getOutputMediaType();
            descriptorOutputTypeSchema = operationDescriptor.getOutputTypeSchema();
        }
        return this.buildIOTypeMetadata(apiOperationModel.getOutputMetadataModel(), connectorDescriptor.getDefaultOutputMediaType(), descriptorOutputMediaType, descriptorOutputTypeSchema, null);
    }

    private TypeDefinition buildIOTypeMetadata(List<APITypeModel> metadataModels, String descriptorGlobalMediaType, String descriptorMediaType, String descriptorTypeSchema, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        MediaType inputMediaType = null;
        if (StringUtils.isNotBlank((CharSequence)descriptorMediaType)) {
            inputMediaType = MediaType.valueOf((String)descriptorMediaType);
        } else if (StringUtils.isNotBlank((CharSequence)descriptorGlobalMediaType)) {
            inputMediaType = MediaType.valueOf((String)descriptorGlobalMediaType);
        }
        if (StringUtils.isNotBlank((CharSequence)descriptorTypeSchema)) {
            if (inputMediaType == null) {
                APITypeModel defaultApiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
                inputMediaType = defaultApiTypeModel.getMediaType();
            }
            return this.typeDefinitionBuilder.buildTypeDefinition(descriptorTypeSchema, inputMediaType);
        }
        return this.buildTypeMetadata(metadataModels, inputMediaType, partDescriptors);
    }

    private TypeDefinition buildTypeMetadata(List<APITypeModel> metadataModels, MediaType mediaType, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        if (!metadataModels.isEmpty()) {
            boolean metadataModelsDefineMediaType = metadataModels.stream().anyMatch(x -> x.getMediaType() != null);
            if (metadataModelsDefineMediaType) {
                APITypeModel apiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
                if (mediaType != null && (apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, mediaType)) == null) {
                    throw new ModelGenerationException("Could not get body with media type from api spec: " + mediaType);
                }
                return this.typeDefinitionBuilder.buildTypeDefinition(apiTypeModel, partDescriptors);
            }
            APITypeModel apiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
            return this.typeDefinitionBuilder.buildTypeDefinition(apiTypeModel, partDescriptors, mediaType);
        }
        return null;
    }

    private static APITypeModel getDefaultApiTypeModel(List<APITypeModel> metadataModels) {
        APITypeModel apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, MediaType.APPLICATION_JSON_TYPE);
        if (apiTypeModel == null) {
            apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, MediaType.APPLICATION_XML_TYPE);
        }
        return apiTypeModel == null ? metadataModels.get(0) : apiTypeModel;
    }

    private static APITypeModel getApiTypeModelByMediaType(List<APITypeModel> metadataModels, MediaType mediaType) {
        return metadataModels.stream().filter(x -> x.getMediaType() != null && x.getMediaType().equals((Object)mediaType)).findFirst().orElse(null);
    }
}

