/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.parameter;

import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.util.HashCodeUtil;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class Parameter {
    private final String internalName;
    private final String externalName;
    private final String displayName;
    private final String description;
    private final boolean required;
    private final String defaultValue;
    private final boolean isPassword;
    private final TypeDefinition typeDefinition;

    public Parameter(String displayName, String externalName, ParameterType parameterType, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password, List<String> collisionInternalNames) {
        this(Parameter.buildInternalName(externalName, collisionInternalNames, parameterType), displayName, externalName, typeDefinition, description, required, defaultValue, password);
    }

    protected Parameter(String internalName, String displayName, String externalName, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password) {
        this.displayName = displayName;
        this.externalName = externalName;
        this.internalName = internalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
    }

    private static String buildInternalName(String externalName, List<String> collisionInternalNames, ParameterType parameterType) {
        String name = XmlUtils.getXmlName(externalName);
        if (collisionInternalNames != null && collisionInternalNames.stream().anyMatch(x -> x.equalsIgnoreCase(name))) {
            return name + "-" + XmlUtils.getXmlName(parameterType.getName());
        }
        return name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(this.internalName, this.displayName, this.description, this.required, this.defaultValue, this.typeDefinition, this.isPassword);
    }
}

