/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.templating.TemplateEntity;

public abstract class JavaTemplateEntity
extends TemplateEntity {
    protected static final String VALUE_MEMBER = "value";
    protected static final String NAME_MEMBER = "name";
    protected final Path outputDir;
    protected final ConnectorModel connectorModel;

    public JavaTemplateEntity(Path outputDir, ConnectorModel connectorModel) {
        this.outputDir = outputDir;
        this.connectorModel = connectorModel;
    }

    protected void writeClassToFile(TypeSpec clazz, String targetPackage) throws TemplatingException {
        this.writeClassToFile(JavaFile.builder((String)targetPackage, (TypeSpec)clazz).build());
    }

    protected void writeClassToFile(JavaFile javaFile) throws TemplatingException {
        try {
            javaFile.writeTo(this.outputDir.resolve("src/main/java"));
        }
        catch (Exception e) {
            throw new TemplatingException("There was an error when writing " + this.getClass().getName() + " class", e);
        }
    }

    public Path getResourcesPath() {
        return this.outputDir.resolve("src/main/resources");
    }

    public Path getSourcesPath() {
        return this.outputDir.resolve("src");
    }

    protected MethodSpec.Builder generateGetter(FieldSpec fieldSpec, CaseFormat fieldNameCaseFormat) {
        String name = "get" + fieldNameCaseFormat.to(CaseFormat.UPPER_CAMEL, fieldSpec.name);
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldSpec.type).addCode(CodeBlock.builder().addStatement("return this.$N", new Object[]{fieldSpec}).build());
    }

    protected MethodSpec.Builder generateOptionalGetter(FieldSpec fieldSpec, Class<?> type, CaseFormat fieldNameCaseFormat) {
        String name = "get" + fieldNameCaseFormat.to(CaseFormat.UPPER_CAMEL, fieldSpec.name);
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{type})).addCode(CodeBlock.builder().addStatement("return $T.ofNullable(this.$N)", new Object[]{Optional.class, fieldSpec}).build());
    }
}

