/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;
import org.mule.metadata.api.model.MetadataFormat;

public abstract class SdkAbstractStaticTypeResolver
extends JavaTemplateEntity {
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_QNAME_METHOD_NAME = "getQName";
    private static final String GET_FORMAT_METHOD_NAME = "getFormat";
    private final boolean requiresTypeResolver;
    private final boolean requiresToWriteSchema;
    private static final String SCHEMAS_FOLDER = "schemas";
    protected final TypeDefinition typeDefinition;
    private String schemaPath;
    private String className;
    private String javaPackage;
    private String categoryName;
    protected Class<?> superclass;

    public SdkAbstractStaticTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtils.SchemaNameType schemaNameType, String partName) throws TemplatingException {
        super(outputDir, connectorModel);
        this.typeDefinition = typeDefinition;
        this.superclass = this.buildSuperclass(typeDefinition);
        this.requiresTypeResolver = this.buildRequiresTypeResolver();
        this.requiresToWriteSchema = this.requiresToWriteSchema();
        if (this.requiresTypeResolver) {
            this.className = this.buildClassName(operation, partName);
            this.javaPackage = this.buildPackage(connectorModel);
            this.categoryName = SdkAbstractStaticTypeResolver.buildCategoryName(operation);
            if (this.requiresToWriteSchema) {
                Path schemasFolder = sdkConnector.getResourcesPath().resolve(SCHEMAS_FOLDER);
                this.schemaPath = "/schemas/" + FileGenerationUtils.writeSchema(typeDefinition.getTypeSchema(), schemasFolder, operation, schemaNameType, partName, sdkConnector.getTypeSchemaPaths());
            }
        }
    }

    protected abstract Class<?> buildSuperclass(TypeDefinition var1) throws TemplatingException;

    protected abstract String getClassNameSuffix();

    private String buildClassName(ConnectorOperation operation, String partName) {
        return JavaUtils.getJavaUpperCamelNameFromXml(operation.getInternalName()) + (StringUtils.isNotBlank((CharSequence)partName) ? JavaUtils.getJavaUpperCamelNameFromXml(XmlUtils.getXmlName(partName)) : "") + this.getClassNameSuffix();
    }

    private static String buildCategoryName(ConnectorOperation operation) {
        return operation.getInternalName() + "-type-resolver";
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.operation.metadata";
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.requiresTypeResolver) {
            this.generateTypeResolverClass();
        }
    }

    private void generateTypeResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        if (this.requiresToWriteSchema) {
            this.addGetSchemaPathMethod(typeResolverClassBuilder);
        }
        if (this.requiresCategoryNameMethod()) {
            this.addGetCategoryNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresQNameMethod()) {
            this.addGetQNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresFormatMethod()) {
            this.addFormatMethod(typeResolverClassBuilder);
        }
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    private void addFormatMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return new $1T($2S, $2S, $2S)", new Object[]{MetadataFormat.class, this.typeDefinition.getMediaType().getType() + "/" + this.typeDefinition.getMediaType().getSubtype()}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_FORMAT_METHOD_NAME).returns(TypeName.get(MetadataFormat.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetSchemaPathMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.schemaPath}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_SCHEMA_PATH_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.categoryName}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetQNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.getQName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_QNAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    protected boolean requiresCategoryNameMethod() {
        return true;
    }

    protected abstract boolean requiresQNameMethod();

    protected abstract boolean requiresFormatMethod();

    protected abstract String getQName();

    protected boolean buildRequiresTypeResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition);
    }

    public boolean getRequiresTypeResolver() {
        return this.requiresTypeResolver;
    }

    protected abstract boolean requiresToWriteSchema();
}

