/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.AbstractSdkOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnectionProvider;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkOperationFactory;
import org.mule.connectors.restconnect.commons.api.configuration.RestConnectConfiguration;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;

public class SdkConfig
extends JavaTemplateEntity {
    private final SdkConnector connector;
    private final List<SdkConnectionProvider> connectionProviders;
    private final List<AbstractSdkOperation> operations;

    public SdkConfig(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector) throws TemplatingException {
        super(outputDir, connectorModel);
        this.connector = sdkConnector;
        this.connectionProviders = connectorModel.getOperations().stream().map(ConnectorOperation::getSecuritySchemes).flatMap(Collection::stream).distinct().map(scheme -> new SdkConnectionProvider(outputDir, connectorModel, sdkConnector, (ConnectorSecurityScheme)scheme)).collect(Collectors.toList());
        this.operations = new LinkedList<AbstractSdkOperation>();
        for (ConnectorOperation operation : connectorModel.getOperations()) {
            this.operations.add(SdkOperationFactory.create(outputDir, connectorModel, sdkConnector, operation));
        }
    }

    public String getJavaClassName() {
        String baseName = this.connector.getJavaName().endsWith("Connector") ? this.connector.getJavaName().substring(0, this.connector.getJavaName().length() - 9) : this.connector.getJavaName();
        return baseName + "Configuration";
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.configuration";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConfigClass();
        for (SdkConnectionProvider connectionProvider : this.connectionProviders) {
            connectionProvider.applyTemplates();
        }
        for (AbstractSdkOperation operation : this.operations) {
            operation.applyTemplates();
        }
    }

    private void generateConfigClass() throws TemplatingException {
        TypeSpec.Builder configClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(RestConnectConfiguration.class).addAnnotation(this.getConfigurationAnnotation()).addAnnotation(this.getOperationsAnnotation()).addAnnotation(this.getConnectionProvidersAnnotation());
        this.writeClassToFile(configClassBuilder.build(), this.getPackage());
    }

    private AnnotationSpec getOperationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.operations.size(); ++i) {
            AbstractSdkOperation operation = this.operations.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)operation.getPackage(), (String)operation.getJavaClassName(), (String[])new String[0])});
            if (i >= this.operations.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder operationsAnnotationBuilder = AnnotationSpec.builder(Operations.class).addMember("value", codeBlock.build());
        return operationsAnnotationBuilder.build();
    }

    private AnnotationSpec getConnectionProvidersAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.connectionProviders.size(); ++i) {
            SdkConnectionProvider connectionProvider = this.connectionProviders.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)connectionProvider.getPackage(), (String)connectionProvider.getJavaClassName(), (String[])new String[0])});
            if (i >= this.connectionProviders.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder connectionProvidersAnnotationBuilder = AnnotationSpec.builder(ConnectionProviders.class).addMember("value", codeBlock.build());
        return connectionProvidersAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationAnnotation() {
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Configuration.class);
        return extensionAnnotationBuilder.build();
    }
}

