/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkParameter;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;
import org.mule.connectors.restconnect.commons.api.connection.BaseConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.BasicAuthConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.DigestConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.MandatoryTlsParameterGroup;
import org.mule.connectors.restconnect.commons.api.connection.OptionalTlsParameterGroup;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.connection.TlsParameterGroup;
import org.mule.connectors.restconnect.commons.api.connection.oauth.BaseAuthorizationCodeConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.oauth.BaseClientCredentialsConnectionProvider;
import org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

public class SdkConnectionProvider
extends JavaTemplateEntity {
    private static final String JAVA_DOC_BASE_URI = "@return the base uri of the REST API being consumed";
    private static final String CREATE_CONNECTION_METHOD_NAME = "createConnection";
    private static final String CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME = "httpClient";
    private static final String CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME = "authentication";
    private static final String CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME = "defaultQueryParams";
    private static final String CREATE_CONNECTION_HEADERS_PARAMETER_NAME = "defaultHeaders";
    private final ConnectorSecurityScheme securityScheme;
    private final List<SdkParameter> headers;
    private final List<SdkParameter> queryParameters;

    public SdkConnectionProvider(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorSecurityScheme securityScheme) {
        super(outputDir, connectorModel);
        this.securityScheme = securityScheme;
        this.headers = securityScheme.getHeaders().stream().map(parameter -> new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), (Parameter)parameter)).collect(Collectors.toList());
        this.queryParameters = securityScheme.getQueryParameters().stream().map(parameter -> new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), (Parameter)parameter)).collect(Collectors.toList());
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.connection";
    }

    private String getConnectionProviderXmlName() {
        return XmlUtils.getXmlName(this.securityScheme.getDisplayName());
    }

    private String getConnectionProviderDisplayName() {
        return WordUtils.capitalize((String)this.getConnectionProviderXmlName().replace('-', ' ')) + " Connection Provider";
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml(this.getConnectionProviderXmlName()) + "ConnectionProvider";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectionProviderClass();
    }

    private void generateConnectionProviderClass() throws TemplatingException {
        FieldSpec baseUriField = this.generateBaseUriField();
        TypeSpec.Builder connectionProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getConnectionProviderClass()).addAnnotation(this.generateAliasAnnotation()).addAnnotation(this.generateDisplayNameAnnotation()).addField(baseUriField).addMethod(this.generateGetter(baseUriField, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).addJavadoc(CodeBlock.builder().add(JAVA_DOC_BASE_URI, new Object[0]).add("\n", new Object[0]).build()).build());
        this.addOAuth(connectionProviderClassBuilder);
        this.addTls(connectionProviderClassBuilder);
        this.addCreateConnectionOverrideMethod(connectionProviderClassBuilder);
        for (SdkParameter header : this.headers) {
            this.addParameterField(connectionProviderClassBuilder, header);
        }
        for (SdkParameter queryParam : this.queryParameters) {
            this.addParameterField(connectionProviderClassBuilder, queryParam);
        }
        this.writeClassToFile(connectionProviderClassBuilder.build(), this.getPackage());
    }

    private void addParameterField(TypeSpec.Builder connectionProviderClassBuilder, SdkParameter parameter) {
        FieldSpec.Builder fieldBuilder = this.securityScheme.getSecuritySchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2) ? parameter.generateOAuthParameterField() : parameter.generateParameterField();
        fieldBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(this.generateSdkParameterJavaDoc(parameter));
        connectionProviderClassBuilder.addField(fieldBuilder.build());
    }

    private void addCreateConnectionOverrideMethod(TypeSpec.Builder connectionProviderClassBuilder) {
        if (!(this.headers.isEmpty() && this.queryParameters.isEmpty() || this.securityScheme.getSecuritySchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2))) {
            MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)CREATE_CONNECTION_METHOD_NAME).returns(TypeName.get(RestConnection.class)).addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(HttpClient.class, CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME, new Modifier[0]).addParameter(HttpAuthentication.class, CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME, new Modifier[0]).addParameter(this.getStringMultiMapTypeName(), CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME, new Modifier[0]).addParameter(this.getStringMultiMapTypeName(), CREATE_CONNECTION_HEADERS_PARAMETER_NAME, new Modifier[0]).addCode(this.generateCreateConnectionMethodBody()).build();
            connectionProviderClassBuilder.addMethod(createConnectionMethod);
        }
    }

    private CodeBlock generateCreateConnectionMethodBody() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        this.addCustomParameters(methodBody, this.queryParameters, CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME);
        this.addCustomParameters(methodBody, this.headers, CREATE_CONNECTION_HEADERS_PARAMETER_NAME);
        methodBody.addStatement("return super.createConnection($L, $L, $L, $L)", new Object[]{CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME, CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME, CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME, CREATE_CONNECTION_HEADERS_PARAMETER_NAME});
        return methodBody.build();
    }

    private void addCustomParameters(CodeBlock.Builder methodBody, List<SdkParameter> parameters, String parametersParameterName) {
        if (!parameters.isEmpty()) {
            methodBody.beginControlFlow("if($L == null)", new Object[]{parametersParameterName}).addStatement("$L = new $T.StringMultiMap()", new Object[]{parametersParameterName, MultiMap.class}).endControlFlow();
            for (SdkParameter header : parameters) {
                methodBody.beginControlFlow("if($T.isNotBlank($L))", new Object[]{RestConnectUtils.class, header.getJavaName()}).addStatement("$L.put($S, $L)", new Object[]{parametersParameterName, header.getExternalName(), header.getJavaName()}).endControlFlow();
            }
        }
    }

    private TypeName getStringMultiMapTypeName() {
        return ParameterizedTypeName.get(MultiMap.class, (Type[])new Type[]{String.class, String.class});
    }

    private void addTls(TypeSpec.Builder connectionProviderClassBuilder) {
        if (this.connectorModel.supportsHTTPS()) {
            FieldSpec tlsField = this.generateTlsField();
            CodeBlock.Builder tlsJavaDocBuilder = CodeBlock.builder();
            if (this.connectorModel.supportsHTTP()) {
                tlsJavaDocBuilder.add("\n{@link $L} that configures TLS and allows to switch between HTTP and HTTPS protocols.\n\n", new Object[]{TlsParameterGroup.class.getSimpleName()});
            } else {
                tlsJavaDocBuilder.add("\n{@link $L} that configures TLS for this connection.\n\n", new Object[]{TlsParameterGroup.class.getSimpleName()});
            }
            tlsJavaDocBuilder.add("@return an optional {@link $L}", new Object[]{TlsParameterGroup.class.getSimpleName()}).build();
            connectionProviderClassBuilder.addField(tlsField).addMethod(this.generateOptionalGetter(tlsField, TlsParameterGroup.class, CaseFormat.LOWER_CAMEL).addJavadoc(tlsJavaDocBuilder.build()).build());
        }
    }

    private void addOAuth(TypeSpec.Builder connectionProviderClassBuilder) throws TemplatingException {
        if (this.securityScheme.getSecuritySchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2)) {
            AnnotationSpec oAuthAnnotation = null;
            if (this.getConnectionProviderClass().equals(BaseClientCredentialsConnectionProvider.class)) {
                OAuth2ClientCredentialsScheme clientCredentials = (OAuth2ClientCredentialsScheme)this.securityScheme;
                oAuthAnnotation = AnnotationSpec.builder(ClientCredentials.class).addMember("tokenUrl", "$S", new Object[]{clientCredentials.getAccessTokenUri()}).addMember("defaultScopes", "$S", new Object[]{clientCredentials.getScopes()}).build();
            } else if (this.getConnectionProviderClass().equals(BaseAuthorizationCodeConnectionProvider.class)) {
                OAuth2AuthorizationCodeScheme authorizationCode = (OAuth2AuthorizationCodeScheme)this.securityScheme;
                oAuthAnnotation = AnnotationSpec.builder(AuthorizationCode.class).addMember("accessTokenUrl", "$S", new Object[]{authorizationCode.getAccessTokenUri()}).addMember("authorizationUrl", "$S", new Object[]{authorizationCode.getAuthorizationUri()}).addMember("defaultScopes", "$S", new Object[]{authorizationCode.getScopes()}).build();
            }
            if (oAuthAnnotation != null) {
                connectionProviderClassBuilder.addAnnotation(oAuthAnnotation);
            }
        }
    }

    private CodeBlock generateSdkParameterJavaDoc(SdkParameter sdkParameter) {
        return CodeBlock.builder().add("$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)sdkParameter.getDescription(), (CharSequence)sdkParameter.getDisplayName())}).build();
    }

    private Class<? extends BaseConnectionProvider> getConnectionProviderClass() throws TemplatingException {
        ConnectorSecurityScheme.SecuritySchemeType securitySchemeType = this.securityScheme.getSecuritySchemeType();
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.BASIC)) {
            return BasicAuthConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.DIGEST_AUTHENTICATION)) {
            return DigestConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.PASS_THROUGH)) {
            return BaseConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.UNSECURED)) {
            return BaseConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2)) {
            if (((OAuth2Scheme)this.securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE)) {
                return BaseAuthorizationCodeConnectionProvider.class;
            }
            if (((OAuth2Scheme)this.securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.CLIENT_CREDENTIALS)) {
                return BaseClientCredentialsConnectionProvider.class;
            }
        }
        throw new TemplatingException("Connection Provider not available for " + (Object)((Object)securitySchemeType));
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.getConnectionProviderDisplayName()}).build();
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.getConnectionProviderXmlName()}).build();
    }

    private FieldSpec generateBaseUriField() {
        FieldSpec.Builder baseUriFieldSpec = FieldSpec.builder(String.class, (String)"baseUri", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{"Base Uri"}).build()).addAnnotation(AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{this.connectorModel.getBaseUri().getType().getDescription()}).build()).addJavadoc(CodeBlock.builder().add(JAVA_DOC_BASE_URI, new Object[0]).build());
        if (this.connectorModel.getBaseUri().isParameterizedBaseUri()) {
            baseUriFieldSpec.addAnnotation(org.mule.runtime.extension.api.annotation.param.Parameter.class).addAnnotation(this.buildBaseUriOptionalAnnotation(this.connectorModel.getBaseUri()));
        } else {
            baseUriFieldSpec.initializer("\"" + this.connectorModel.getBaseUri().getUri() + "\"", new Object[0]);
        }
        return baseUriFieldSpec.build();
    }

    private AnnotationSpec buildBaseUriOptionalAnnotation(BaseUri baseUri) {
        AnnotationSpec.Builder optionalAnnotationBuilder = AnnotationSpec.builder(Optional.class);
        if (StringUtils.isNotBlank((CharSequence)baseUri.getUri())) {
            optionalAnnotationBuilder.addMember("defaultValue", "$S", new Object[]{this.connectorModel.getBaseUri().getUri()});
        }
        return optionalAnnotationBuilder.build();
    }

    private FieldSpec generateTlsField() {
        Class tlsClass = this.connectorModel.supportsHTTP() ? OptionalTlsParameterGroup.class : MandatoryTlsParameterGroup.class;
        return FieldSpec.builder(tlsClass, (String)"tlsConfig", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc(CodeBlock.builder().add("{@link $L} references to a TLS config element. This will enable HTTPS for this config.\n", new Object[]{tlsClass.getSimpleName()}).build()).addAnnotation(AnnotationSpec.builder(ParameterGroup.class).addMember("name", "$S", new Object[]{"tls"}).build()).build();
    }
}

