/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.BooleanInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateOnlyInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateTimeInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FileInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FromJsonInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.IntegerInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.JsonInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.NumberInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.StringInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.TimeOnlyInputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.XmlInputTypeResolver;

public class SdkInputTypeResolver
extends SdkAbstractStaticTypeResolver {
    private String qName;

    public SdkInputTypeResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtils.SchemaNameType schemaNameType, String partName) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveTypeResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlInputTypeResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return JsonInputTypeResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return FromJsonInputTypeResolver.class;
        }
        return StringInputTypeResolver.class;
    }

    protected Class<?> getPrimitiveTypeResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
            return DateTimeInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyInputTypeResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileInputTypeResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    @Override
    protected String getClassNameSuffix() {
        return "InputTypeResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlInputTypeResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonInputTypeResolver.class) || this.superclass.equals(FileInputTypeResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonInputTypeResolver.class) || this.superclass.equals(JsonInputTypeResolver.class) || this.superclass.equals(XmlInputTypeResolver.class);
    }
}

