/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class BaseJavaPackageMustBeValidRule
extends PreValidationRule {
    public BaseJavaPackageMustBeValidRule() {
        super("Descriptor baseJavaPackage must ve a valid java package name", "When present in the connector descriptor, baseJavaPackage property must be a valid java package.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String javaPackage = connectorDescriptor.getBaseJavaPackage();
        if (StringUtils.isBlank((CharSequence)javaPackage)) {
            return validationResults;
        }
        String validJavaPackage = JavaUtils.removeJavaPackageUnwantedCharacters(javaPackage);
        if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "Descriptor baseJavaPackage");
    }
}

