/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.NamingUtil;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class ConnectorNameMustBeFriendlyRule
extends PreValidationRule {
    public ConnectorNameMustBeFriendlyRule() {
        super("connectorName property seems not to be a friendly name", "The connectorName declared in the descriptor should be a human readable name separated with spaces.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String connectorName = connectorDescriptor.getConnectorName();
        if (StringUtils.isNotBlank((CharSequence)connectorName) && !NamingUtil.isFriendlyName(connectorName)) {
            validationResults.add(this.getValidationError(connectorName));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(String name) {
        return new ValidationResult(this, "connectorName : " + name);
    }
}

