/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;

public class AMFPrimitiveTypeModel
extends APIPrimitiveTypeModel {
    private static final Map<String, PrimitiveTypeDefinition.PrimitiveType> scalarTypeMappings = new HashMap<String, PrimitiveTypeDefinition.PrimitiveType>();

    public AMFPrimitiveTypeModel(Shape shape) {
        this.primitiveType = this.getPrimitiveType(shape);
    }

    public AMFPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType primitiveTypeDefinition) {
        this.primitiveType = primitiveTypeDefinition;
    }

    private PrimitiveTypeDefinition.PrimitiveType getPrimitiveType(Shape shape) {
        if (shape instanceof ScalarShape) {
            return scalarTypeMappings.get(((ScalarShape)shape).dataType().value());
        }
        if (shape instanceof FileShape) {
            return PrimitiveTypeDefinition.PrimitiveType.FILE;
        }
        throw new IllegalArgumentException("Type declaration is not a primitive type.");
    }

    static {
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", PrimitiveTypeDefinition.PrimitiveType.BOOLEAN);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", PrimitiveTypeDefinition.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", PrimitiveTypeDefinition.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", PrimitiveTypeDefinition.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", PrimitiveTypeDefinition.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", PrimitiveTypeDefinition.PrimitiveType.DATE_TIME);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY);
    }
}

