/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.OAuth2Settings;

public class AMFOauth2FlowsNaming {
    private AMFOauth2FlowsNaming() {
    }

    public static boolean isAuthorizationCode(OAuth2Settings oAuth2Settings) {
        if (oAuth2Settings.authorizationGrants() != null && !oAuth2Settings.authorizationGrants().isEmpty()) {
            for (StrField grant : oAuth2Settings.authorizationGrants()) {
                if (!"authorization_code".equalsIgnoreCase(grant.value())) continue;
                return true;
            }
        }
        if (oAuth2Settings.flow().nonEmpty()) {
            return "accessCode".equalsIgnoreCase(oAuth2Settings.flow().value());
        }
        return false;
    }

    public static boolean isClientCredentials(OAuth2Settings oAuth2Settings) {
        if (oAuth2Settings.authorizationGrants() != null && !oAuth2Settings.authorizationGrants().isEmpty()) {
            for (StrField grant : oAuth2Settings.authorizationGrants()) {
                if (!"client_credentials".equalsIgnoreCase(grant.value())) continue;
                return true;
            }
        }
        if (oAuth2Settings.flow().nonEmpty()) {
            return "application".equalsIgnoreCase(oAuth2Settings.flow().value());
        }
        return false;
    }
}

