/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPTypeModel;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;

public class RPParameterModel
extends APIParameterModel {
    private final TypeDeclaration typeDeclaration;

    public RPParameterModel(TypeDeclaration typeDeclaration, ParameterType parameterType, boolean isPassword) {
        this.typeDeclaration = typeDeclaration;
        this.externalName = typeDeclaration.name();
        this.displayName = this.buildDisplayName();
        this.parameterType = parameterType;
        this.defaultValue = this.buildDefaultValue();
        this.description = this.buildDescription();
        this.isPassword = isPassword;
        this.isRequired = typeDeclaration.required();
        this.typeModel = new RPTypeModel(typeDeclaration, this.getDefaultMediaType(typeDeclaration));
    }

    private String getDefaultMediaType(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof FileTypeDeclaration) {
            return "application/octet-stream";
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof ArrayTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration || typeDeclaration instanceof JSONTypeDeclaration) {
            return "application/json";
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            return "application/xml";
        }
        return "text/plain";
    }

    private String buildDisplayName() {
        return this.typeDeclaration.displayName() != null ? this.typeDeclaration.displayName().value() : this.typeDeclaration.name();
    }

    private String buildDefaultValue() {
        String defaultValue = this.typeDeclaration.defaultValue();
        return StringUtils.isNotBlank((CharSequence)defaultValue) ? defaultValue : null;
    }

    private String buildDescription() {
        return this.typeDeclaration.description() == null ? null : StringUtils.trimToNull((String)this.typeDeclaration.description().value());
    }
}

