package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ClassCreationConfig;

public class AbstractClassBuilder<FUNCTION, R> {
    private final FUNCTION executionStrategy;
    private final ClassCreationConfig<R> config;

    public AbstractClassBuilder(FUNCTION executionStrategy, ClassCreationConfig<R> config) {
        this.executionStrategy = executionStrategy;
        this.config = config;
    }

    protected FUNCTION getExecutionStrategy() {
        return executionStrategy;
    }

    protected ClassCreationConfig<R> getConfig() {
        return config;
    }
}
