package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ClassCreationConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;

public class BiParamClassBuilder<A, B, R> extends GenericClassBuilder<BiFunction<A, B, R>, A, MonoParamClassBuilder<B, R>, R> {

    public BiParamClassBuilder(BiFunction<A, B, R> executionStrategy, ClassCreationConfig<R> config) {
        super(executionStrategy, config);
    }

    @Override
    public MonoParamClassBuilder<B, R> withParam(A currentParam) {
        return new MonoParamClassBuilder<>((secondParam) -> getExecutionStrategy().apply(currentParam, secondParam), getConfig());
    }
}
