package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ClassCreationConfig;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TetraFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.supplier.Supplier;

public class ClassBuilder<R> {

    private ClassCreationConfig<R> config = new ClassCreationConfig<>(null);

    public ClassBuilder withConfig(ClassCreationConfig<R> config) {
        this.config = config;
        return this;
    }

    public <A, B, C, D, E> PentaParamClassBuilder<A, B, C, D, E, R> create(PentaFunction<A, B, C, D, E, R> executionStrategy) {
        return new PentaParamClassBuilder<>(executionStrategy, config);
    }

    public <A, B, C, D> TetraParamClassBuilder<A, B, C, D, R> create(TetraFunction<A, B, C, D, R> executionStrategy) {
        return new TetraParamClassBuilder<>(executionStrategy, config);
    }

    public <A, B, C> TriParamClassBuilder<A, B, C, R> create(TriFunction<A, B, C, R> executionStrategy) {
        return new TriParamClassBuilder<>(executionStrategy, config);
    }

    public <A, B> BiParamClassBuilder<A, B, R> create(BiFunction<A, B, R> executionStrategy) {
        return new BiParamClassBuilder<>(executionStrategy, config);
    }

    public <A> MonoParamClassBuilder<A, R> create(Function<A, R> executionStrategy) {
        return new MonoParamClassBuilder<>(executionStrategy, config);
    }

    public ExecutionBuilder<R> create(Supplier<R> executionStrategy) {
        return new NoParamClassBuilder<>(executionStrategy, config).create();
    }

}
