package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ClassCreationConfig;
import org.mule.connectors.atlantic.commons.builder.exception.UnhandledException;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.supplier.Supplier;

import java.util.Optional;

public class NoParamClassBuilder<R> extends AbstractClassBuilder<Supplier<R>, R> {

    public NoParamClassBuilder(Supplier<R> executionStrategy,
                               ClassCreationConfig<R> config) {
        super(executionStrategy, config);
    }

    public ExecutionBuilder<R> create() {
        try {
            return new ExecutionBuilder<>(getExecutionStrategy().apply());
        } catch (Throwable t) {
            try {
                return Optional.ofNullable(getConfig().getExceptionHandlers()
                        .stream()
                        .filter(handler -> handler.getHandledException()
                                .isInstance(t))
                        .findFirst()
                        .orElseThrow(() -> new UnhandledException(t))
                        .handle(t))
                        .map(ExecutionBuilder::new)
                        .orElse(null);
            } catch (RuntimeException e) {
                throw e;
            } catch (Throwable throwable) {
                throw new UnhandledException(throwable);
            }

        }
    }
}
