package org.mule.connectors.atlantic.commons.builder.config;

public class DefinedExceptionHandler<T extends Throwable, R> implements ExceptionHandler<T, R> {
    private final Class<T> handledException;
    private final ExceptionHandler<T, R> exceptionHandler;

    public DefinedExceptionHandler(Class<T> handledException, ExceptionHandler<T, R> exceptionHandler) {
        this.handledException = handledException;
        this.exceptionHandler = exceptionHandler;
    }

    public Class<T> getHandledException() {
        return handledException;
    }

    @Override
    public R handle(Throwable throwable) throws Throwable{
        return exceptionHandler.handle((T)throwable);
    }
}
